/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation;

import jasima.core.experiment.Experiment;
import jasima.core.simulation.SimComponent;
import jasima.core.simulation.SimPrintMessage;
import jasima.core.simulation.Simulation;
import jasima.core.simulation.util.SimOperations;
import jasima.core.util.MsgCategory;
import jasima.core.util.SimProcessUtil;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Year;
import java.time.ZoneOffset;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class SimulationExperiment
extends Experiment
implements SimOperations {
    private static final long serialVersionUID = 5208352155973550329L;
    private double simulationLength = Double.NaN;
    private double initialSimTime = 0.0;
    private double statsResetTime = 0.0;
    private long simTimeToMillisFactor = 60000L;
    private Instant simTimeStartInstant = null;
    private List<Consumer<Simulation>> initActions = null;
    private SimComponent modelRoot = null;
    private SimProcessUtil.SimAction mainProcess = null;
    protected transient Simulation sim;

    public SimulationExperiment() {
        this(null);
    }

    public SimulationExperiment(SimProcessUtil.SimAction mainProcess) {
        this.setMainProcess(mainProcess);
    }

    @Override
    protected void init() {
        super.init();
        this.sim = this.createSim();
        this.initSim();
        this.createSimComponents();
        this.sim.init();
        if (this.initActions != null) {
            this.initActions.forEach(a -> a.accept(this.sim));
        }
    }

    protected void initSim() {
        this.sim.setInitialSimTime(this.getInitialSimTime());
        this.sim.setPrintLevel(this.getLogLevel());
        this.sim.getRndStreamFactory().setSeed(this.getInitialSeed());
        this.sim.setMainProcessActions(this.getMainProcess());
        if (this.getSimulationLength() >= 0.0) {
            this.sim.setSimulationLength(this.getSimulationLength());
        }
        if (this.getSimTimeStartInstant() != null) {
            this.sim.setSimTimeStartInstant(this.getSimTimeStartInstant());
        } else {
            LocalDate yearBeg = LocalDate.of(Year.now(Clock.systemUTC()).getValue(), 1, 1);
            this.sim.setSimTimeStartInstant(yearBeg.atStartOfDay(ZoneOffset.UTC).toInstant());
        }
        this.sim.setSimTimeToMillisFactor(this.getSimTimeToMillisFactor());
        if (this.getModelRoot() != null) {
            this.sim.addComponent(this.getModelRoot());
        }
        this.sim.addPrintListener(this::print);
    }

    protected Simulation createSim() {
        return new Simulation();
    }

    protected void createSimComponents() {
    }

    protected void print(SimPrintMessage event) {
        if (event.getCategory().ordinal() < MsgCategory.TRACE.ordinal()) {
            this.print(event.getCategory(), "sim_message\t%s", event);
        }
    }

    @Override
    protected void beforeRun() {
        this.sim.beforeRun();
    }

    @Override
    protected void performRun() {
        this.sim.run();
    }

    @Override
    protected void afterRun() {
        this.sim.afterRun();
    }

    @Override
    protected void done() {
        this.sim.done();
    }

    @Override
    protected void produceResults() {
        super.produceResults();
        this.sim.produceResults(this.resultMap);
    }

    @Override
    public double toSimTime(Duration d) {
        double millis = d.toMillis();
        return millis / (double)this.simTimeToMillisFactor;
    }

    @Override
    public Simulation getSim() {
        if (this.sim == null) {
            throw new IllegalStateException("no simulation.");
        }
        return this.sim;
    }

    public void setSimulationLength(double simulationLength) {
        this.simulationLength = simulationLength;
    }

    public double getSimulationLength() {
        return this.simulationLength;
    }

    public void setStatsResetTime(double statsResetTime) {
        this.statsResetTime = statsResetTime;
    }

    public double getStatsResetTime() {
        return this.statsResetTime;
    }

    public double getInitialSimTime() {
        return this.initialSimTime;
    }

    public void setInitialSimTime(double initialSimTime) {
        this.initialSimTime = initialSimTime;
    }

    public void addInitAction(Consumer<Simulation> action) {
        if (this.initActions == null) {
            this.initActions = new ArrayList<Consumer<Simulation>>();
        }
        this.initActions.add(action);
    }

    public Instant getSimTimeStartInstant() {
        return this.simTimeStartInstant;
    }

    public void setSimTimeStartInstant(Instant simTimeStartInstant) {
        this.simTimeStartInstant = simTimeStartInstant;
    }

    public long getSimTimeToMillisFactor() {
        return this.simTimeToMillisFactor;
    }

    public void setSimTimeToMillisFactor(long simTimeToMillisFactor) {
        this.simTimeToMillisFactor = simTimeToMillisFactor;
    }

    public void setSimTimeToMillisFactor(TemporalUnit u) {
        this.setSimTimeToMillisFactor(Duration.of(1L, u).toMillis());
    }

    public SimComponent getModelRoot() {
        return this.modelRoot;
    }

    public void setModelRoot(SimComponent rootComponent) {
        this.modelRoot = rootComponent;
    }

    public SimProcessUtil.SimAction getMainProcess() {
        return this.mainProcess;
    }

    public void setMainProcess(SimProcessUtil.SimAction mainProcess) {
        this.mainProcess = mainProcess;
    }

    @Override
    public SimulationExperiment clone() {
        SimulationExperiment c = (SimulationExperiment)super.clone();
        if (this.initActions != null) {
            c.initActions = new ArrayList<Consumer<Simulation>>(this.initActions);
        }
        if (this.modelRoot != null) {
            c.modelRoot = this.modelRoot.clone();
        }
        return c;
    }
}

