/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation;

import jasima.core.simulation.Simulation;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Objects;

final class SimulationClock
extends Clock {
    private final Simulation sim;
    private final ZoneId zone;

    SimulationClock(Simulation sim, ZoneId zone) {
        this.sim = Objects.requireNonNull(sim);
        this.zone = Objects.requireNonNull(zone);
    }

    @Override
    public ZoneId getZone() {
        return this.zone;
    }

    @Override
    public Instant instant() {
        return this.sim.simTimeAbs();
    }

    @Override
    public Clock withZone(ZoneId zone) {
        if (zone.equals(this.zone)) {
            return this;
        }
        return new SimulationClock(this.sim, zone);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof SimulationClock) {
            SimulationClock sc = (SimulationClock)obj;
            return this.zone.equals(sc.zone) && this.sim.equals(sc.sim);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.sim, this.zone);
    }

    public String toString() {
        return "SimulationClock[" + this.zone + "]";
    }
}

