/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation;

import jasima.core.random.RandomFactory;
import jasima.core.random.continuous.DblSequence;
import jasima.core.simulation.EventHeap;
import jasima.core.simulation.EventQueue;
import jasima.core.simulation.SimComponent;
import jasima.core.simulation.SimContext;
import jasima.core.simulation.SimEntity;
import jasima.core.simulation.SimEvent;
import jasima.core.simulation.SimPrintMessage;
import jasima.core.simulation.SimProcess;
import jasima.core.simulation.SimulationClock;
import jasima.core.simulation.util.ProcessActivator;
import jasima.core.simulation.util.SimComponentRoot;
import jasima.core.simulation.util.SimOperations;
import jasima.core.util.ComponentStates;
import jasima.core.util.MsgCategory;
import jasima.core.util.SimProcessUtil;
import jasima.core.util.TypeUtil;
import jasima.core.util.Util;
import jasima.core.util.ValueStore;
import jasima.core.util.ValueStoreImpl;
import jasima.core.util.i18n.I18n;
import jasima.core.util.observer.Notifier;
import jasima.core.util.observer.NotifierImpl;
import jasima.core.util.observer.ObservableValue;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class Simulation
implements ValueStore,
SimOperations,
ProcessActivator,
Notifier<Simulation, SimLifecycleEvent> {
    private NotifierImpl<Simulation, SimLifecycleEvent> notifierAdapter;
    public static final String SIM_TIME = "simTime";
    public static final String QUEUE_IMPL_KEY = "jasima.core.simulation.Simulation.queueImpl";
    public static final Class<? extends EventQueue> queueImpl = TypeUtil.getClassFromSystemProperty("jasima.core.simulation.Simulation.queueImpl", EventQueue.class, EventHeap.class);
    private double simulationLength = 0.0;
    private double initialSimTime = 0.0;
    private int initialEventPriority = 0;
    private double statsResetTime = 0.0;
    private RandomFactory rndStreamFactory;
    private String name = null;
    private long simTimeToMillisFactor = Duration.ofMinutes(1L).toMillis();
    private Instant simTimeStartInstant;
    private ErrorHandler errorHandler = null;
    private ValueStoreImpl valueStore;
    private SimComponentRoot rootComponent;
    private MsgCategory printLevel = MsgCategory.INFO;
    private ArrayList<Consumer<SimPrintMessage>> printListener;
    private Locale locale = I18n.DEF_LOCALE;
    private ZoneId zoneId = ZoneId.of("UTC");
    private SimProcessUtil.SimAction mainProcessActions = null;
    private double simTime;
    private int currPrio;
    private SimEvent currEvent;
    private long numEventsProcessed;
    private Clock clock;
    private boolean awakePausedWorker;
    private Thread pausedWorkerThread;
    private ConcurrentLinkedQueue<SimProcessUtil.SimAction> runInSimThread;
    private EventQueue events;
    private int eventNum;
    private int numAppEvents;
    final ObservableValue<SimExecState> state = new ObservableValue<SimExecState>(SimExecState.INITIAL);
    private volatile boolean endRequested;
    private AtomicInteger pauseRequests = new AtomicInteger(0);
    private Exception execFailure;
    private SimEvent simEndEvent;
    private SimProcess<?> mainProcess;
    private Set<SimProcess<?>> runnableProcesses;
    private SimProcess<?> currentProcess;
    private SimProcess<?> eventLoopProcess;
    private Map<String, Object> additionalResults;
    private Map<String, Object> res;

    @Override
    public NotifierImpl<Simulation, SimLifecycleEvent> notifierImpl() {
        if (this.notifierAdapter == null) {
            this.notifierAdapter = new NotifierImpl(this);
        }
        return this.notifierAdapter;
    }

    public static Map<String, Object> of(SimProcessUtil.SimRunnable r) {
        return SimContext.simulationOf(r);
    }

    public static Map<String, Object> of(String name, SimProcessUtil.SimRunnable r) {
        return SimContext.simulationOf(name, r);
    }

    public static Map<String, Object> of(SimComponent ... components) {
        return SimContext.simulationOf(components);
    }

    public static Map<String, Object> of(String name, SimComponent ... components) {
        return SimContext.simulationOf(name, components);
    }

    public static Map<String, Object> of(SimProcessUtil.SimAction a) {
        return SimContext.simulationOf(a);
    }

    public static Map<String, Object> of(String name, SimProcessUtil.SimAction a) {
        return SimContext.simulationOf(name, a);
    }

    public Simulation() {
        this.runInSimThread = new ConcurrentLinkedQueue();
        this.printListener = new ArrayList();
        this.valueStore = new ValueStoreImpl();
        this.runnableProcesses = new HashSet();
        RandomFactory randomFactory = RandomFactory.newInstance();
        this.setRndStreamFactory(randomFactory);
        this.events = this.createEventQueue();
        this.currEvent = new SimEvent(Double.NEGATIVE_INFINITY, Integer.MIN_VALUE){

            @Override
            public void handle() {
            }
        };
        this.currPrio = this.currEvent.getPrio();
        this.simTime = this.currEvent.getTime();
        this.eventNum = Integer.MIN_VALUE;
        this.numAppEvents = 0;
        this.numEventsProcessed = 0L;
        LocalDate yearBeg = LocalDate.of(Year.now(Clock.systemUTC()).getValue(), 1, 1);
        this.simTimeStartInstant = yearBeg.atStartOfDay(ZoneOffset.UTC).toInstant();
        this.rootComponent = new SimComponentRoot();
        this.addListener(this.rootComponent);
    }

    public void addPrintListener(Consumer<SimPrintMessage> listener) {
        this.printListener.add(listener);
    }

    public boolean removePrintListener(Consumer<SimPrintMessage> listener) {
        return this.printListener.remove(listener);
    }

    public int numPrintListener() {
        return this.printListener.size();
    }

    public List<Consumer<SimPrintMessage>> printListener() {
        return Collections.unmodifiableList(this.printListener);
    }

    public void init() {
        ComponentStates.requireAllowedState(this.state.get(), SimExecState.INITIAL);
        this.state.set(SimExecState.INIT);
        this.simTime = this.getInitialSimTime();
        this.currPrio = this.getInitialEventPriority();
        this.additionalResults = new LinkedHashMap<String, Object>();
        this.initComponentTree(null, this.rootComponent);
        this.fire(StdSimLifecycleEvents.INIT);
    }

    protected void initComponentTree(SimComponent parent, SimComponent child) {
        child.setParent(parent);
        child.setSim(this);
        child.getChildren().forEach(c -> this.initComponentTree(child, (SimComponent)c));
    }

    public void run() {
        ComponentStates.requireAllowedState(this.state.get(), SimExecState.BEFORE_RUN);
        this.mainProcess = new SimProcess(this, this.getMainProcessActions(), "simMain");
        this.currEvent = this.mainProcess.activateProcessEvent;
        this.setCurrentProcess(this.mainProcess);
        this.setEventLoopProcess(this.mainProcess);
        this.execFailure = null;
        this.state.set(SimExecState.RUNNING);
        this.resetStats();
        this.checkInitialEventTime();
        this.mainProcess.activateProcess();
        this.mainProcess.run();
        this.terminateRunningProcesses();
        if (this.execFailure != null) {
            this.state.set(SimExecState.ERROR);
            throw new SimulationFailed("There was an unrecoverable error during simulation run.", this.execFailure);
        }
        this.state.set(SimExecState.FINISHED);
    }

    private void terminateRunningProcesses() {
        for (SimProcess<?> p : this.runnableProcesses()) {
            if (p == this.mainProcess() || p.executor == null) continue;
            p.terminateWaiting();
            while (p.executor != null) {
            }
        }
    }

    void handleNextEvent() {
        SimEvent evt;
        SimProcessUtil.SimAction r;
        while ((r = this.runInSimThread.poll()) != null) {
            try {
                r.run(this);
            }
            catch (SimProcess.MightBlock e) {
                throw new AssertionError();
            }
        }
        if (!this.continueSim()) {
            return;
        }
        this.currEvent = evt = this.events.extract();
        this.simTime = evt.getTime();
        this.currPrio = evt.getPrio();
        if (evt.isAppEvent()) {
            --this.numAppEvents;
        }
        ++this.numEventsProcessed;
        this.runEventHandler(evt);
    }

    protected void runEventHandler(SimEvent evt) {
        evt.handle();
    }

    private void checkInitialEventTime() {
        if (this.continueSim()) {
            SimEvent e = this.events.extract();
            if (e.getTime() < this.simTime) {
                throw new IllegalArgumentException(this.createErrorMsgEventInPast(e, this.simTime));
            }
            this.events.insert(e);
        }
    }

    boolean handleError(Exception e) {
        return this.getErrorHandler() != null ? this.getErrorHandler().test(e) : this.defaultErrorHandler(e);
    }

    protected boolean defaultErrorHandler(Exception e) {
        String errorString = Util.exceptionToString(e);
        this.printFmt(MsgCategory.ERROR, "An uncaught exception occurred. Current event='%s', exception='%s'", this.currentEvent(), errorString);
        return true;
    }

    private String createErrorMsgEventInPast(SimEvent e, double simTime) {
        return I18n.defFormat("Can't schedule an event that is in the past (time to schedule: %f, simTime: %f, prio=%d, event=%s).", e.getTime(), simTime, e.getPrio(), e.toString());
    }

    public void beforeRun() {
        ComponentStates.requireAllowedState(this.state.get(), SimExecState.INIT);
        this.state.set(SimExecState.BEFORE_RUN);
        this.simEndEvent = new SimEvent(this.getInitialSimTime() + this.getSimulationLength(), Integer.MAX_VALUE){

            @Override
            public void handle() {
                if (Simulation.this.simTime() == this.getTime()) {
                    Simulation.this.end();
                }
            }
        };
        if (this.getSimulationLength() > 0.0) {
            this.schedule(this.simEndEvent);
        }
        this.fire(StdSimLifecycleEvents.SIM_START);
    }

    protected void resetStats() {
        ComponentStates.requireAllowedState(this.state.get(), SimExecState.RUNNING);
        if (this.getStatsResetTime() > this.getInitialSimTime()) {
            this.scheduleAt("statsReset", this.getStatsResetTime(), 0x5FFFFFFD, () -> this.fire(StdSimLifecycleEvents.RESET_STATS));
        }
        this.fire(StdSimLifecycleEvents.RESET_STATS);
    }

    public void afterRun() {
        this.fire(StdSimLifecycleEvents.SIM_END);
    }

    public void done() {
        this.fire(StdSimLifecycleEvents.DONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> performRun() {
        SimContext.setThreadContext(this);
        try {
            long runTimeReal = System.currentTimeMillis();
            this.init();
            this.beforeRun();
            this.run();
            this.afterRun();
            this.done();
            runTimeReal = System.currentTimeMillis() - runTimeReal;
            LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>();
            res.put("runTime", (double)runTimeReal / 1000.0);
            this.produceResults(res);
            LinkedHashMap<String, Object> linkedHashMap = res;
            return linkedHashMap;
        }
        finally {
            SimContext.setThreadContext(null);
        }
    }

    public Future<Map<String, Object>> performRunAsync(ExecutorService pool) {
        return pool.submit(this::performRun);
    }

    public Future<Map<String, Object>> performRunAsync() {
        return this.performRunAsync(Util.DEF_POOL);
    }

    public boolean unschedule(SimEvent event) {
        return this.events.remove(event);
    }

    @Override
    public SimEvent schedule(SimEvent event) {
        if (event.getTime() == this.simTime && event.getPrio() <= this.currPrio) {
            this.printFmt(MsgCategory.WARN, "Priority inversion (current: %d, scheduled: %d, event=%s).", this.currPrio, event.getPrio(), event.toString());
        }
        if (event.getTime() < this.simTime) {
            String msg = this.createErrorMsgEventInPast(event, this.simTime);
            this.printFmt(MsgCategory.ERROR, msg, new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        event.eventNum = this.eventNum++;
        if (event.isAppEvent()) {
            ++this.numAppEvents;
        }
        this.events.insert(event);
        return event;
    }

    @Override
    public void schedulePeriodically(final double firstInvocation, final double interval, int prio, final BooleanSupplier method) {
        this.schedule(new SimEvent(firstInvocation, prio){
            private int n;
            {
                super(time, prio);
                this.n = 0;
            }

            @Override
            public void handle() {
                if (method.getAsBoolean()) {
                    this.setTime(firstInvocation + (double)(++this.n) * interval);
                    Simulation.this.schedule(this);
                }
            }
        });
    }

    @Override
    public void schedulePeriodically(final double firstInvocation, final double interval, int prio, final Runnable method) {
        this.schedule(new SimEvent(firstInvocation, prio){
            private int n;
            {
                super(time, prio);
                this.n = 0;
            }

            @Override
            public void handle() {
                method.run();
                this.setTime(firstInvocation + (double)(++this.n) * interval);
                Simulation.this.schedule(this);
            }
        });
    }

    @Override
    public void scheduleProcess(int prio, DoubleSupplier method) {
        this.scheduleProcess(Math.max(this.simTime(), this.getInitialSimTime()), prio, method);
    }

    @Override
    public void scheduleProcess(double firstInvocation, int prio, final DoubleSupplier method) {
        this.schedule(new SimEvent(firstInvocation, prio){

            @Override
            public void handle() {
                double next = method.getAsDouble();
                if (next >= 0.0) {
                    this.setTime(next);
                    Simulation.this.schedule(this);
                }
            }
        });
    }

    @Override
    public void end() {
        this.endRequested = true;
        if (this.pauseRequests.get() > 0) {
            this.awakePausedWorker = true;
            LockSupport.unpark(this.pausedWorkerThread);
            this.pausedWorkerThread = null;
        }
    }

    @Override
    public boolean isEndRequested() {
        return this.endRequested;
    }

    public void pause() {
        ComponentStates.requireAllowedState(this.state.get(), EnumSet.complementOf(EnumSet.of(SimExecState.FINISHED, SimExecState.ERROR)));
        if (this.pauseRequests.incrementAndGet() == 1) {
            this.awakePausedWorker = false;
            this.runInSimThread(() -> {
                if (this.pauseRequests.get() > 0) {
                    assert (this.state.get() == SimExecState.RUNNING);
                    this.state.set(SimExecState.PAUSED);
                    this.pausedWorkerThread = Thread.currentThread();
                    while (!this.awakePausedWorker && !this.pausedWorkerThread.isInterrupted()) {
                        LockSupport.park();
                    }
                    this.state.set(SimExecState.RUNNING);
                }
            });
        }
    }

    public void unpause() {
        ComponentStates.requireAllowedState(this.state.get(), SimExecState.PAUSED, SimExecState.RUNNING);
        if (this.pauseRequests.decrementAndGet() == 0 && this.pausedWorkerThread != null) {
            this.awakePausedWorker = true;
            LockSupport.unpark(this.pausedWorkerThread);
            this.pausedWorkerThread = null;
        }
    }

    @Override
    public double simTime() {
        if (this.state.get() == SimExecState.INITIAL) {
            throw new IllegalStateException("simTime() is undefined for an uninitialized simulation.");
        }
        return this.simTime;
    }

    public Clock clock() {
        if (this.clock != null) {
            this.clock = new SimulationClock(this, this.zoneId);
        }
        return this.clock;
    }

    public LocalDateTime simTimeToLocalDateTime() {
        return this.simTimeToLocalDateTime(this.simTimeToInstant(this.simTime()));
    }

    public LocalDateTime simTimeToLocalDateTime(double simTime) {
        return this.simTimeToLocalDateTime(this.simTimeToInstant(simTime));
    }

    public LocalDateTime simTimeToLocalDateTime(Instant instant) {
        return LocalDateTime.ofInstant(Objects.requireNonNull(instant), this.getZoneId());
    }

    @Override
    public Instant simTimeToInstant(double simTime) {
        long simTimeMillis = Math.round((simTime - this.getInitialSimTime()) * (double)this.simTimeToMillisFactor);
        return this.getSimTimeStartInstant().plus(simTimeMillis, ChronoUnit.MILLIS);
    }

    public Duration simTimeToDuration(double simTime) {
        double millis = simTime * (double)this.simTimeToMillisFactor;
        return Duration.of(Math.round(millis), ChronoUnit.MILLIS);
    }

    @Override
    public double toSimTime(Instant instant) {
        double durationMillis = instant.toEpochMilli() - this.getSimTimeStartInstant().toEpochMilli();
        return durationMillis / (double)this.simTimeToMillisFactor + this.getInitialSimTime();
    }

    @Override
    public double toSimTime(Duration d) {
        double millis = d.toMillis();
        return millis / (double)this.simTimeToMillisFactor;
    }

    @Override
    public double toSimTime(long numUnits, TemporalUnit u) {
        return this.toSimTime(Duration.of(numUnits, u));
    }

    @Override
    public int currentPrio() {
        if (this.state.get() == SimExecState.INITIAL) {
            throw new IllegalStateException("currentPrio() is undefined for an uninitialized simulation.");
        }
        return this.currPrio;
    }

    public SimEvent currentEvent() {
        return this.currEvent;
    }

    @Nullable
    public SimProcess<?> currentProcess() {
        return this.currentProcess;
    }

    public SimExecState state() {
        return this.state.get();
    }

    public ObservableValue<SimExecState> observableState() {
        return this.state;
    }

    public long numEventsProcessed() {
        return this.numEventsProcessed;
    }

    public long numAppEvents() {
        return this.numAppEvents;
    }

    public long numEvents() {
        return this.events.size();
    }

    public List<SimEvent> scheduledEvents() {
        return this.events.allEvents();
    }

    public void produceResults(Map<String, Object> res) {
        this.res = res;
        try {
            res.putAll(this.additionalResults);
            res.put(SIM_TIME, this.simTime());
            this.fire(new ProduceResultsMessage(res));
        }
        finally {
            res = null;
        }
    }

    @Override
    public void addResult(String name, Object value) {
        if (this.res != null) {
            this.res.put(name, value);
        } else {
            this.additionalResults.put(name, value);
        }
    }

    @Override
    public <T extends SimEntity> T activateEntity(T e) {
        return this.activateComponent(e);
    }

    <T extends SimComponent> T activateComponent(T sc) {
        this.activateComponents(sc);
        return sc;
    }

    void activateComponents(SimComponent ... scs) {
        ComponentStates.requireAllowedState(this.state.get(), SimExecState.INIT, new SimExecState[]{SimExecState.BEFORE_RUN, SimExecState.RUNNING, SimExecState.PAUSED});
        for (SimComponent sc : scs) {
            sc.setSim(this);
        }
        switch (this.state.get()) {
            case INITIAL: {
                break;
            }
            case INIT: {
                for (SimComponent sc : scs) {
                    sc.inform(this, StdSimLifecycleEvents.INIT);
                }
                break;
            }
            case BEFORE_RUN: {
                for (SimComponent sc : scs) {
                    sc.inform(this, StdSimLifecycleEvents.INIT);
                }
                for (SimComponent sc : scs) {
                    sc.inform(this, StdSimLifecycleEvents.SIM_START);
                }
                break;
            }
            case RUNNING: 
            case PAUSED: {
                for (SimComponent sc : scs) {
                    sc.inform(this, StdSimLifecycleEvents.INIT);
                }
                for (SimComponent sc : scs) {
                    sc.inform(this, StdSimLifecycleEvents.SIM_START);
                }
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public SimComponent getComponentByHierarchicalName(String hierarchicalName) {
        return this.getRootComponent().getByHierarchicalName(hierarchicalName);
    }

    public void print(String message) {
        this.print(MsgCategory.INFO, message);
    }

    public void print(MsgCategory category, String message) {
        if (this.numPrintListener() > 0 && category.ordinal() <= this.getPrintLevel().ordinal()) {
            this.print(new SimPrintMessage(this, category, message));
        }
    }

    public void print(MsgCategory category, Object ... params) {
        if (this.numPrintListener() > 0 && category.ordinal() <= this.getPrintLevel().ordinal()) {
            this.print(new SimPrintMessage(this, category, params));
        }
    }

    protected void print(SimPrintMessage e) {
        this.printListener.forEach((Consumer<Consumer<SimPrintMessage>>)((Consumer<Consumer>)l -> l.accept(e)));
    }

    @Override
    public void trace(Object ... params) {
        this.print(MsgCategory.TRACE, params);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.getPrintLevel().ordinal() >= MsgCategory.TRACE.ordinal();
    }

    public MsgCategory getPrintLevel() {
        return this.printLevel;
    }

    public void setPrintLevel(MsgCategory printLevel) {
        Objects.requireNonNull(printLevel);
        this.printLevel = printLevel;
    }

    public void printFmt(MsgCategory category, final String messageFormatString, final Object ... params) {
        if (this.numPrintListener() > 0 && category.ordinal() <= this.getPrintLevel().ordinal()) {
            Object msgProducer = new Object(){

                public String toString() {
                    return I18n.defFormat(messageFormatString, params);
                }
            };
            this.print(new SimPrintMessage(this, category, msgProducer));
        }
    }

    public void printFmt(String messageFormatString, Object ... params) {
        this.printFmt(MsgCategory.INFO, messageFormatString, params);
    }

    protected EventQueue createEventQueue() {
        return TypeUtil.createInstance(queueImpl);
    }

    public void setSimulationLength(double simulationLength) {
        double simEndTime;
        if (!(simulationLength >= 0.0)) {
            throw new IllegalArgumentException("" + simulationLength);
        }
        this.simulationLength = simulationLength;
        if (this.simEndEvent != null && (simEndTime = this.simTime() + this.getSimulationLength()) != this.simEndEvent.getTime()) {
            this.simEndEvent.setTime(simEndTime);
            this.schedule(this.simEndEvent);
        }
    }

    public double getSimulationLength() {
        return this.simulationLength;
    }

    public RandomFactory getRndStreamFactory() {
        return this.rndStreamFactory;
    }

    public void setRndStreamFactory(RandomFactory rndStreamFactory) {
        this.rndStreamFactory = rndStreamFactory;
        rndStreamFactory.setSim(this);
    }

    @Override
    public <T extends DblSequence> T initRndGen(T s, String streamName) {
        return this.getRndStreamFactory().initRndGen(s, streamName);
    }

    @Override
    public Random initRndGen(String streamName) {
        return this.getRndStreamFactory().createInstance(streamName);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public SimComponentRoot getRootComponent() {
        return this.rootComponent;
    }

    public double getInitialSimTime() {
        return this.initialSimTime;
    }

    public void setInitialSimTime(double initialSimTime) {
        ComponentStates.requireAllowedState(this.state.get(), SimExecState.INIT, SimExecState.INITIAL);
        this.initialSimTime = initialSimTime;
    }

    public int getInitialEventPriority() {
        return this.initialEventPriority;
    }

    public void setInitialEventPriority(int initialEventPriority) {
        this.initialEventPriority = initialEventPriority;
    }

    public Instant getSimTimeStartInstant() {
        return this.simTimeStartInstant;
    }

    public void setSimTimeStartInstant(Instant simTimeStartInstant) {
        long epochMillis = simTimeStartInstant.toEpochMilli();
        this.simTimeStartInstant = Instant.ofEpochMilli(epochMillis);
    }

    public long getSimTimeToMillisFactor() {
        return this.simTimeToMillisFactor;
    }

    public double getStatsResetTime() {
        return this.statsResetTime;
    }

    public void setStatsResetTime(double statsResetTime) {
        this.statsResetTime = statsResetTime;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(ZoneId zone) {
        this.zoneId = zone;
    }

    public String message(Enum<?> key) {
        return I18n.message(this.getLocale(), key);
    }

    public String message(String keyName) {
        return I18n.message(this.getLocale(), keyName);
    }

    public String formattedMessage(Enum<?> key, Object ... params) {
        return I18n.formattedMessage(this.getLocale(), key, params);
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setSimTimeToMillisFactor(long simTimeToMillisFactor) {
        this.simTimeToMillisFactor = simTimeToMillisFactor;
    }

    public void setSimTimeToMillisFactor(TemporalUnit u) {
        this.setSimTimeToMillisFactor(Duration.of(1L, u).toMillis());
    }

    public boolean continueSim() {
        return this.numAppEvents > 0 && !this.endRequested;
    }

    public void runInSimThread(Runnable r) {
        this.runInSimThread(SimProcessUtil.simActionFromRunnable(r));
    }

    public void runInSimThread(SimProcessUtil.SimAction a) {
        this.runInSimThread.add(a);
    }

    SimProcess<?> mainProcess() {
        return this.mainProcess;
    }

    void setCurrentProcess(SimProcess<?> p) {
        this.currentProcess = p;
    }

    void terminateWithException(Exception e) {
        this.execFailure = Objects.requireNonNull(e);
        this.endRequested = true;
    }

    SimProcess<?> getEventLoopProcess() {
        return this.eventLoopProcess;
    }

    void setEventLoopProcess(SimProcess<?> eventLoopProcess) {
        this.eventLoopProcess = eventLoopProcess;
    }

    @Override
    public ValueStore valueStoreImpl() {
        return this.valueStore;
    }

    @Override
    public Simulation getSim() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processTerminated(SimProcess<?> simProcess) {
        Set<SimProcess<?>> set = this.runnableProcesses;
        synchronized (set) {
            boolean removeRes = this.runnableProcesses.remove(simProcess);
            assert (removeRes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processNew(SimProcess<?> simProcess) {
        Set<SimProcess<?>> set = this.runnableProcesses;
        synchronized (set) {
            this.runnableProcesses.add(simProcess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numRunnableProcesses() {
        Set<SimProcess<?>> set = this.runnableProcesses;
        synchronized (set) {
            return this.runnableProcesses.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SimProcess<?>> runnableProcesses() {
        Set<SimProcess<?>> set = this.runnableProcesses;
        synchronized (set) {
            return Collections.unmodifiableList(new ArrayList(this.runnableProcesses));
        }
    }

    public SimProcessUtil.SimAction getMainProcessActions() {
        return this.mainProcessActions;
    }

    public void setMainProcessActions(SimProcessUtil.SimRunnable r) {
        this.setMainProcessActions(SimProcessUtil.simAction(r));
    }

    public void setMainProcessActions(SimProcessUtil.SimAction mainProcessActions) {
        ComponentStates.requireAllowedState(this.state.get(), SimExecState.INITIAL, SimExecState.INIT);
        this.mainProcessActions = mainProcessActions;
    }

    public static enum SimExecState {
        INITIAL,
        INIT,
        BEFORE_RUN,
        RUNNING,
        PAUSED,
        TERMINATING,
        FINISHED,
        ERROR;

    }

    public static class SimulationFailed
    extends RuntimeException {
        private static final long serialVersionUID = 4068987513637601189L;

        SimulationFailed(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    @FunctionalInterface
    public static interface ErrorHandler
    extends Predicate<Exception> {
        @Override
        public boolean test(Exception var1);
    }

    public static class ProduceResultsMessage
    implements SimLifecycleEvent {
        public final Map<String, Object> resultMap;

        public ProduceResultsMessage(Map<String, Object> resultMap) {
            this.resultMap = resultMap;
        }

        public String toString() {
            return "ProduceResultsMsg";
        }
    }

    public static enum StdSimLifecycleEvents implements SimLifecycleEvent
    {
        INIT,
        SIM_START,
        RESET_STATS,
        SIM_END,
        DONE;

    }

    public static interface SimLifecycleEvent {
    }
}

