/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation;

import jasima.core.simulation.SimComponent;
import jasima.core.simulation.SimContext;
import jasima.core.simulation.SimEvent;
import jasima.core.simulation.Simulation;
import jasima.core.simulation.util.SimEventMethodCall;
import jasima.core.util.ComponentStates;
import jasima.core.util.SequenceNumberService;
import jasima.core.util.SimProcessUtil;
import jasima.core.util.observer.DerivedObservable;
import jasima.core.util.observer.ObservableValue;
import jasima.core.util.observer.ObservableValues;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimProcess<R>
implements Runnable {
    private static final Logger log = LogManager.getLogger(SimProcess.class);
    private final Simulation sim;
    private final SimProcessUtil.SimCallable<R> action;
    private final String name;
    private Simulation.ErrorHandler localErrorHandler;
    private SimComponent owner;
    private ArrayList<Consumer<SimProcess<R>>> completionNotifiers;
    private ProcessState state;
    private R execResult;
    private Exception execFailure;
    final SimEvent activateProcessEvent;
    Thread executor;
    private volatile boolean wasSignaled;
    private boolean reactivated;

    public SimProcess(Simulation sim) {
        this(sim, (SimProcessUtil.SimCallable)null, null);
    }

    public SimProcess(Simulation sim, SimProcessUtil.SimRunnable r) {
        this(sim, SimProcessUtil.simCallable(r), null);
    }

    public SimProcess(Simulation sim, Callable<R> c) {
        this(sim, SimProcessUtil.simCallable(c), null);
    }

    public SimProcess(Simulation sim, SimProcessUtil.SimAction a) {
        this(sim, SimProcessUtil.simCallable(a), null);
    }

    public SimProcess(Simulation sim, SimProcessUtil.SimCallable<R> c) {
        this(sim, c, null);
    }

    public SimProcess(Simulation sim, SimProcessUtil.SimRunnable r, String name) {
        this(sim, SimProcessUtil.simCallable(r), name);
    }

    public SimProcess(Simulation sim, Callable<R> c, String name) {
        this(sim, SimProcessUtil.simCallable(c), name);
    }

    public SimProcess(Simulation sim, SimProcessUtil.SimAction a, String name) {
        this(sim, SimProcessUtil.simCallable(a), name);
    }

    public SimProcess(Simulation sim, SimProcessUtil.SimCallable<R> action, String name) {
        this.sim = Objects.requireNonNull(sim);
        this.name = name != null ? name : SequenceNumberService.getFor(sim).nextFormattedValue("simProcess");
        this.action = action;
        this.localErrorHandler = null;
        this.executor = null;
        this.state = ProcessState.PASSIVE;
        this.activateProcessEvent = new SimEventMethodCall(sim.simTime(), sim.currentPrio() + 1, "ActivateProcess", this::activateProcess);
        this.sim.processNew(this);
    }

    protected R lifecycle() throws Exception {
        if (this.action != null) {
            return this.action.call(this.sim);
        }
        return null;
    }

    private boolean handleError(Exception e, boolean skipLocal) {
        boolean shouldRethrow = true;
        if (this.localErrorHandler != null && !skipLocal) {
            shouldRethrow = this.localErrorHandler.test(e);
        }
        if (shouldRethrow) {
            shouldRethrow = this.sim.handleError(e);
        }
        return shouldRethrow;
    }

    @Override
    public void run() {
        ComponentStates.requireAllowedState(this.state, ProcessState.RUNNING);
        this.executor = SimProcessUtil.currentExecutor();
        String oldName = this.executor.getName();
        this.executor.setName(this.getName());
        SimContext.setThreadContext(this.sim);
        assert (this.sim.currentProcess() == this);
        assert (this.sim.getEventLoopProcess() == this);
        log.trace("process started: {}", (Object)this.getName());
        try {
            block11: {
                try {
                    this.execResult = this.lifecycle();
                    this.execFailure = null;
                    this.state = ProcessState.TERMINATED;
                    this.sim.processTerminated(this);
                }
                catch (Exception e) {
                    this.execResult = null;
                    this.execFailure = e;
                    this.state = ProcessState.ERROR;
                    this.sim.processTerminated(this);
                    if (!this.handleError(e, false)) break block11;
                    this.sim.terminateWithException(e);
                }
            }
            log.trace("actions finished, " + (this.completionNotifiers == null ? "null" : "" + this.completionNotifiers.size()));
            this.runCompleteCallbacks();
            log.trace("callbacks run");
            this.yield();
            log.trace("yielded");
        }
        catch (TerminateProcess tp) {
            log.trace("process terminated: " + this.getName() + "  " + this.sim.currentProcess() + "  " + this.sim.getEventLoopProcess());
        }
        catch (Throwable t) {
            System.err.println(Thread.currentThread() + " " + t);
            t.printStackTrace();
            throw t;
        }
        finally {
            log.trace("process finished: {}", (Object)this.getName());
            this.executor.setName(oldName);
            this.executor = null;
            SimContext.setThreadContext(null);
        }
    }

    private void yield() {
        assert (this.sim.getEventLoopProcess() == this);
        assert (SimContext.currentSimulation() == this.sim);
        this.sim.setCurrentProcess(null);
        this.reactivated = false;
        while (!this.reactivated && this.sim.continueSim()) {
            try {
                this.sim.handleNextEvent();
            }
            catch (RuntimeException e) {
                if (!this.handleError(e, true)) continue;
                this.sim.terminateWithException(e);
            }
        }
        if (!this.reactivated && !this.sim.continueSim()) {
            log.trace("backtomain");
            this.sim.state.set(Simulation.SimExecState.TERMINATING);
            if (this.isMainProcess()) {
                throw new TerminateProcess();
            }
            this.sim.mainProcess().activateProcess();
        }
    }

    void activateProcess() {
        if (this.sim.state() != Simulation.SimExecState.TERMINATING) {
            ComponentStates.requireAllowedState(this.state, ProcessState.PASSIVE, ProcessState.SCHEDULED);
            this.state = ProcessState.RUNNING;
        }
        this.sim.setCurrentProcess(this);
        log.trace("process activating: {}", (Object)this.getName());
        SimProcess<?> current = this.sim.getEventLoopProcess();
        if (current != this) {
            this.sim.setEventLoopProcess(this);
            this.start();
            super.pause();
        } else {
            this.reactivated = true;
        }
    }

    void terminateWaiting() {
        log.trace("trying to terminate " + this.getName() + " in state " + (Object)((Object)this.state) + ", executor=" + this.executor);
        assert (this.sim.state() == Simulation.SimExecState.TERMINATING);
        this.start();
    }

    private void start() {
        assert (!this.hasFinished() || this.isMainProcess() || this.sim.state() == Simulation.SimExecState.TERMINATING);
        if (this.executor == null) {
            ComponentStates.requireAllowedState(this.state, ProcessState.RUNNING);
            SimProcessUtil.startExecuting(this);
        } else {
            this.reactivated = true;
            this.wasSignaled = true;
            SimProcessUtil.continueWith(this.executor);
        }
    }

    private void pause() throws TerminateProcess {
        if (this.hasFinished() && !this.isMainProcess()) {
            this.reactivated = true;
            return;
        }
        while (!this.wasSignaled) {
            SimProcessUtil.pauseExecuting(this.executor);
        }
        this.wasSignaled = false;
        if (this.sim.state() == Simulation.SimExecState.TERMINATING) {
            throw new TerminateProcess();
        }
    }

    private boolean isMainProcess() {
        return this == this.sim.mainProcess();
    }

    public void resume() {
        this.awakeAt(this.sim.simTime());
        log.trace("process {} resuming", (Object)this.getName());
    }

    public void awakeIn(double deltaT) {
        this.awakeAt(this.sim.simTime() + deltaT);
    }

    public void awakeIn(long amount, TemporalUnit u) {
        this.awakeIn(this.sim.simTime() + this.sim.toSimTime(amount, u));
    }

    public void awakeIn(Duration d) {
        this.awakeIn(this.sim.simTime() + this.sim.toSimTime(d));
    }

    public void awakeAt(double tAbs) {
        ComponentStates.requireAllowedState(this.state, ProcessState.PASSIVE);
        this.scheduleReactivateAt(tAbs);
        this.state = ProcessState.SCHEDULED;
        log.trace("process {} awaking at {}", (Object)this.getName(), (Object)tAbs);
    }

    public void awakeAt(Instant instant) {
        this.awakeAt(this.sim.toSimTime(instant));
    }

    public SimProcess<R> cancel() {
        ComponentStates.requireAllowedState(this.state, ProcessState.SCHEDULED);
        this.sim.unschedule(this.activateProcessEvent);
        this.state = ProcessState.PASSIVE;
        log.trace("waiting process canceled: {}", (Object)this.getName());
        return this;
    }

    public SimProcess<R> waitFor(double deltaT) throws MightBlock {
        this.waitUntil(this.sim.simTime() + deltaT);
        return this;
    }

    public SimProcess<R> waitFor(long amount, TemporalUnit u) throws MightBlock {
        this.waitUntil(this.sim.simTime() + this.sim.toSimTime(amount, u));
        return this;
    }

    public SimProcess<R> waitFor(Duration d) throws MightBlock {
        this.waitUntil(this.sim.simTime() + this.sim.toSimTime(d));
        return this;
    }

    public SimProcess<R> waitUntil(double tAbs) throws MightBlock {
        ComponentStates.requireAllowedState(this.state, ProcessState.RUNNING);
        assert (this.sim.currentEvent() == this.activateProcessEvent);
        assert (this.sim.currentProcess() == this);
        this.scheduleReactivateAt(tAbs);
        this.state = ProcessState.SCHEDULED;
        log.trace("process {} waiting until {}", (Object)this.getName(), (Object)tAbs);
        this.yield();
        return this;
    }

    public SimProcess<R> waitUntil(Instant instant) throws MightBlock {
        this.waitUntil(this.sim.toSimTime(instant));
        return this;
    }

    public boolean waitCondition(ObservableValue<Boolean> triggerCondition) throws MightBlock {
        if (!Boolean.TRUE.equals(triggerCondition.get())) {
            ObservableValues.whenTrueExecuteOnce(triggerCondition, this::resume);
            this.suspend();
            return false;
        }
        return true;
    }

    public <T> boolean waitCondition(Function<T, Boolean> triggerCondition, ObservableValue<? extends T> observable) throws MightBlock {
        DerivedObservable<Boolean> c = ObservableValues.fromUnaryOperation(triggerCondition, observable);
        return this.waitCondition(c);
    }

    public <T1, T2> boolean waitCondition(BiFunction<T1, T2, Boolean> triggerCondition, ObservableValue<? extends T1> obs1, ObservableValue<? extends T2> obs2) throws MightBlock {
        DerivedObservable<Boolean> c = ObservableValues.fromBinaryOperation(triggerCondition, obs1, obs2);
        return this.waitCondition(c);
    }

    public SimProcess<R> suspend() throws MightBlock {
        ComponentStates.requireAllowedState(this.state, ProcessState.RUNNING);
        assert (this.sim.currentEvent() == this.activateProcessEvent);
        assert (this.sim.currentProcess() == this);
        this.state = ProcessState.PASSIVE;
        log.trace("process suspended: {}", (Object)this.getName());
        this.yield();
        return this;
    }

    public SimProcess<R> join() throws MightBlock {
        if (this.hasFinished()) {
            return this;
        }
        SimProcess<?> current = this.sim.currentProcess();
        if (current == null) {
            throw new UnsupportedOperationException();
        }
        if (current == this) {
            throw new IllegalStateException("A process can't wait for its own completion.");
        }
        this.addCompletionNotifier(p -> current.scheduleReactivateAt(this.sim.simTime()));
        current.state = ProcessState.PASSIVE;
        log.trace("process {} joining {}", (Object)current.getName(), (Object)this.getName());
        super.yield();
        return this;
    }

    @Nullable
    public R get() {
        if (!this.hasFinished()) {
            throw new IllegalStateException("Process not finished yet.");
        }
        if (this.execFailure != null) {
            throw new RuntimeException(this.execFailure);
        }
        return this.execResult;
    }

    public boolean hasFinished() {
        return this.state == ProcessState.TERMINATED || this.state == ProcessState.ERROR;
    }

    private void scheduleReactivateAt(double t) {
        this.scheduleReactivateAt(t, this.activateProcessEvent.getPrio());
    }

    private void scheduleReactivateAt(double t, int prio) {
        this.activateProcessEvent.setPrio(prio);
        this.activateProcessEvent.setTime(t);
        this.sim.schedule(this.activateProcessEvent);
    }

    public synchronized void addCompletionNotifier(Consumer<SimProcess<R>> callback) {
        if (this.completionNotifiers == null) {
            this.completionNotifiers = new ArrayList();
        }
        this.completionNotifiers.add(callback);
    }

    private synchronized void runCompleteCallbacks() {
        try {
            if (this.completionNotifiers != null) {
                this.completionNotifiers.forEach((Consumer<Consumer<SimProcess<R>>>)((Consumer<Consumer>)callback -> callback.accept(this)));
            }
        }
        finally {
            this.completionNotifiers = null;
        }
    }

    public Simulation getSim() {
        return this.sim;
    }

    public ProcessState processState() {
        return this.state;
    }

    public Simulation.ErrorHandler getLocalErrorHandler() {
        return this.localErrorHandler;
    }

    public void setLocalErrorHandler(Simulation.ErrorHandler h) {
        this.localErrorHandler = h;
    }

    public String getName() {
        String prefix = null;
        if (this.isMainProcess()) {
            prefix = this.sim.getName();
        } else if (this.getOwner() != null) {
            prefix = this.getOwner().getHierarchicalName();
        }
        return prefix != null ? prefix + '.' + this.name : this.name;
    }

    public String toString() {
        return this.getName();
    }

    public SimComponent getOwner() {
        return this.owner;
    }

    public void setOwner(SimComponent owner) {
        this.owner = owner;
    }

    private static final class TerminateProcess
    extends Error {
        private static final long serialVersionUID = 7242165456133430192L;

        private TerminateProcess() {
        }
    }

    public static class MightBlock
    extends Exception {
        private static final long serialVersionUID = 3091300075872193106L;

        private MightBlock() {
        }
    }

    public static enum ProcessState {
        PASSIVE,
        SCHEDULED,
        RUNNING,
        TERMINATED,
        ERROR;

    }
}

