/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation;

import jasima.core.simulation.Simulation;
import jasima.core.util.MsgCategory;
import java.util.Objects;

public class SimPrintMessage {
    private static final Object[] EMPTY = new Object[0];
    private final Simulation sim;
    private final MsgCategory category;
    private final double simTime;
    private final Object[] params;
    private String message;

    public SimPrintMessage(Simulation sim, MsgCategory category, String message) {
        this(sim, category, Objects.requireNonNull(message), EMPTY);
    }

    public SimPrintMessage(Simulation sim, MsgCategory category, Object ... params) {
        this(sim, category, null, Objects.requireNonNull(params));
    }

    protected SimPrintMessage(Simulation sim, MsgCategory category, String msg, Object ... params) {
        this.sim = sim;
        this.simTime = sim.simTime();
        this.category = category;
        this.params = params;
        this.message = msg;
    }

    public Simulation getSim() {
        return this.sim;
    }

    public MsgCategory getCategory() {
        return this.category;
    }

    public double getSimTime() {
        return this.simTime;
    }

    public Object[] getParams() {
        return this.params;
    }

    public String getMessage() {
        if (this.message == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getSimTime());
            for (Object o : this.getParams()) {
                sb.append('\t').append(String.valueOf(o));
            }
            this.message = sb.toString();
        }
        return this.message;
    }

    public String toString() {
        return this.getMessage();
    }
}

