/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation;

import jasima.core.simulation.Simulation;
import jasima.core.util.observer.NotifierListener;
import java.util.Map;

public interface SimLifecycleListener
extends NotifierListener<Simulation, Simulation.SimLifecycleEvent> {
    @Override
    default public void inform(Simulation sim, Simulation.SimLifecycleEvent event) {
        if (event == Simulation.StdSimLifecycleEvents.INIT) {
            this.init();
        } else {
            this.handleOther(sim, event);
        }
    }

    default public void init() {
    }

    default public void simStart() {
    }

    default public void resetStats() {
    }

    default public void simEnd() {
    }

    default public void done() {
    }

    default public void produceResults(Map<String, Object> resultMap) {
    }

    default public void handleOther(Simulation sim, Simulation.SimLifecycleEvent event) {
    }

    @FunctionalInterface
    public static interface OtherListener
    extends SimLifecycleListener {
        @Override
        public void handleOther(Simulation var1, Simulation.SimLifecycleEvent var2);
    }

    @FunctionalInterface
    public static interface ResultsListener
    extends SimLifecycleListener {
        @Override
        public void produceResults(Map<String, Object> var1);
    }

    @FunctionalInterface
    public static interface DoneListener
    extends SimLifecycleListener {
        @Override
        public void done();
    }

    @FunctionalInterface
    public static interface SimEndListener
    extends SimLifecycleListener {
        @Override
        public void simEnd();
    }

    @FunctionalInterface
    public static interface ResetStatsListener
    extends SimLifecycleListener {
        @Override
        public void resetStats();
    }

    @FunctionalInterface
    public static interface SimStartListener
    extends SimLifecycleListener {
        @Override
        public void simStart();
    }

    @FunctionalInterface
    public static interface SimInitialized
    extends SimLifecycleListener {
        @Override
        public void init();
    }
}

