/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation;

import jasima.core.simulation.util.SimOperations;

public abstract class SimEvent
implements Comparable<SimEvent>,
Runnable {
    private static final int PRIO_INCREMENT = 0x1FFFFFFF;
    public static final int EVENT_PRIO_NORMAL = 0;
    public static final int EVENT_PRIO_LOW = 0x1FFFFFFF;
    public static final int EVENT_PRIO_LOWER = 0x3FFFFFFE;
    public static final int EVENT_PRIO_LOWEST = 0x5FFFFFFD;
    public static final int EVENT_PRIO_HIGH = -536870911;
    public static final int EVENT_PRIO_HIGHER = -1073741822;
    public static final int EVENT_PRIO_HIGHEST = -1610612733;
    public static final int EVENT_PRIO_MAX = Integer.MIN_VALUE;
    public static final int EVENT_PRIO_MIN = Integer.MAX_VALUE;
    private double time;
    private int prio;
    private String description;
    int eventNum;

    public SimEvent(double time, int prio) {
        this(time, prio, null);
    }

    public SimEvent(double time, int prio, String description) {
        this.time = time;
        this.prio = prio;
        this.description = description;
    }

    @Override
    public final void run() {
        this.handle();
    }

    public abstract void handle();

    public void setTime(double time) {
        this.time = time;
    }

    public double getTime() {
        return this.time;
    }

    public int getPrio() {
        return this.prio;
    }

    public void setPrio(int newPrio) {
        this.prio = newPrio;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    public boolean isAppEvent() {
        return true;
    }

    public SimOperations.SimEventType eventType() {
        return this.isAppEvent() ? SimOperations.SimEventType.APP_EVENT : SimOperations.SimEventType.UTILITY_EVENT;
    }

    @Override
    public final int compareTo(SimEvent o) {
        if (this.time < o.time) {
            return -1;
        }
        if (this.time > o.time) {
            return 1;
        }
        if (this.prio < o.prio) {
            return -1;
        }
        if (this.prio > o.prio) {
            return 1;
        }
        return this.eventNum < o.eventNum ? -1 : (this.eventNum > o.eventNum ? 1 : 0);
    }

    public String toString() {
        String descr = this.getDescription();
        return descr != null ? descr : super.toString();
    }
}

