/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation;

import jasima.core.simulation.SimComponent;
import jasima.core.simulation.SimComponentContainerBase;
import jasima.core.simulation.SimContext;
import jasima.core.simulation.SimProcess;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalUnit;

public class SimEntity
extends SimComponentContainerBase {
    private SimProcess<Void> lifecycleProcess = null;

    public SimEntity() {
        this(null);
    }

    public SimEntity(String name) {
        super(name, new SimComponent[0]);
    }

    @Override
    public void init() {
        super.init();
        if (this.lifecycleProcess != null) {
            throw new IllegalStateException();
        }
        this.lifecycleProcess = new SimProcess(this.getSim(), this::lifecycle, "lifecycle");
        this.lifecycleProcess.setOwner(this);
    }

    @Override
    public void simStart() {
        super.simStart();
        this.lifecycleProcess.awakeIn(0.0);
    }

    protected void lifecycle() throws SimProcess.MightBlock {
    }

    public SimProcess<Void> getLifecycleProcess() {
        return this.lifecycleProcess;
    }

    public void resume() {
        this.ensureProcessInitialized();
        this.getLifecycleProcess().resume();
    }

    public SimProcess<Void> suspend() throws SimProcess.MightBlock {
        this.ensureProcessInitialized();
        return this.getLifecycleProcess().suspend();
    }

    public SimProcess<Void> join() throws SimProcess.MightBlock {
        this.ensureProcessInitialized();
        return this.getLifecycleProcess().join();
    }

    public void awakeIn(double deltaT) {
        this.ensureProcessInitialized();
        this.getLifecycleProcess().awakeIn(deltaT);
    }

    public void awakeIn(long amount, TemporalUnit u) {
        this.ensureProcessInitialized();
        this.getLifecycleProcess().awakeIn(amount, u);
    }

    public void awakeIn(Duration d) {
        this.ensureProcessInitialized();
        this.getLifecycleProcess().awakeIn(d);
    }

    public void awakeAt(double tAbs) {
        this.ensureProcessInitialized();
        this.getLifecycleProcess().awakeAt(tAbs);
    }

    public void awakeAt(Instant instant) {
        this.ensureProcessInitialized();
        this.getLifecycleProcess().awakeAt(instant);
    }

    public SimProcess<Void> cancel() {
        this.ensureProcessInitialized();
        return this.getLifecycleProcess().cancel();
    }

    private void ensureProcessInitialized() {
        if (this.lifecycleProcess != null) {
            return;
        }
        if (this.sim == null) {
            this.setSim(SimContext.currentSimulation());
        }
        this.lifecycleProcess = new SimProcess(this.getSim(), this::lifecycle, "lifecycle");
    }
}

