/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation;

import jasima.core.random.continuous.DblSequence;
import jasima.core.simulation.SimComponent;
import jasima.core.simulation.SimEntity;
import jasima.core.simulation.SimEvent;
import jasima.core.simulation.SimProcess;
import jasima.core.simulation.Simulation;
import jasima.core.util.SimProcessUtil;
import jasima.core.util.i18n.I18n;
import jasima.core.util.observer.ObservableValue;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalUnit;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;

public class SimContext {
    private static ThreadLocal<Simulation> currentSim = new ThreadLocal();

    @Nullable
    public static Simulation currentSimulation() {
        return currentSim == null ? null : currentSim.get();
    }

    public static Simulation requireSimContext() {
        Simulation s = SimContext.currentSimulation();
        if (s == null) {
            throw new IllegalStateException(SimContext.message(I18nConsts.NO_CONTEXT));
        }
        return s;
    }

    public static SimProcess<?> currentProcess() {
        return SimContext.requireSimContext().currentProcess();
    }

    public static double simTime() {
        return SimContext.requireSimContext().simTime();
    }

    public static double toSimTime(long amount, TemporalUnit u) {
        return SimContext.requireSimContext().toSimTime(amount, u);
    }

    public static double toSimTime(Duration d) {
        return SimContext.requireSimContext().toSimTime(d);
    }

    public static String message(Enum<?> key) {
        return SimContext.requireSimContext().message(key);
    }

    public static String message(String keyName) {
        return SimContext.requireSimContext().message(keyName);
    }

    public static String formattedMessage(Enum<?> key, Object ... params) {
        return SimContext.requireSimContext().formattedMessage(key, params);
    }

    public static SimProcess<Void> activateEntity(SimEntity e) {
        return SimContext.requireSimContext().activateEntity(e).getLifecycleProcess();
    }

    public static SimProcess<Void> activate(SimProcessUtil.SimRunnable r) {
        return SimContext.requireSimContext().activate(r);
    }

    public static SimProcess<Void> activate(String name, SimProcessUtil.SimRunnable r) {
        return SimContext.requireSimContext().activate(name, r);
    }

    public static SimProcess<Void> activate(SimProcessUtil.SimAction a) {
        return SimContext.requireSimContext().activate(a);
    }

    public static SimProcess<Void> activate(String name, SimProcessUtil.SimAction a) {
        return SimContext.requireSimContext().activate(name, a);
    }

    public static <T> SimProcess<T> activateCallable(Callable<T> c) {
        return SimContext.requireSimContext().activateCallable(c);
    }

    public static <T> SimProcess<T> activateCallable(String name, Callable<T> c) {
        return SimContext.requireSimContext().activateCallable(name, c);
    }

    public static <T> SimProcess<T> activateCallable(SimProcessUtil.SimCallable<T> a) {
        return SimContext.requireSimContext().activateCallable(a);
    }

    public static <T> SimProcess<T> activateCallable(String name, SimProcessUtil.SimCallable<T> a) {
        return SimContext.requireSimContext().activateCallable(name, a);
    }

    public static void trace(Object ... params) {
        SimContext.requireSimContext().trace(params);
    }

    public static void end() {
        SimContext.requireSimContext().end();
    }

    public static void addResult(String name, Object value) {
        SimContext.requireSimContext().addResult(name, value);
    }

    public static void waitFor(double deltaT) throws SimProcess.MightBlock {
        SimContext.currentProcess().waitFor(deltaT);
    }

    public static void waitFor(long amount, TemporalUnit u) throws SimProcess.MightBlock {
        SimContext.currentProcess().waitFor(amount, u);
    }

    public static void waitFor(Duration d) throws SimProcess.MightBlock {
        SimContext.currentProcess().waitFor(d);
    }

    public static void waitUntil(double tAbs) throws SimProcess.MightBlock {
        SimContext.currentProcess().waitUntil(tAbs);
    }

    public static void waitUntil(Instant instant) throws SimProcess.MightBlock {
        SimContext.currentProcess().waitUntil(instant);
    }

    public static boolean waitCondition(ObservableValue<Boolean> triggerCondition) throws SimProcess.MightBlock {
        return SimContext.currentProcess().waitCondition(triggerCondition);
    }

    public static <T> boolean waitCondition(Function<T, Boolean> triggerCondition, ObservableValue<? extends T> observable) throws SimProcess.MightBlock {
        return SimContext.currentProcess().waitCondition(triggerCondition, observable);
    }

    public static <T1, T2> boolean waitCondition(BiFunction<T1, T2, Boolean> triggerCondition, ObservableValue<? extends T1> obs1, ObservableValue<? extends T2> obs2) throws SimProcess.MightBlock {
        return SimContext.currentProcess().waitCondition(triggerCondition, obs1, obs2);
    }

    public static void suspend() throws SimProcess.MightBlock {
        SimContext.currentProcess().suspend();
    }

    public static SimEvent schedule(SimEvent event) {
        return SimContext.requireSimContext().schedule(event);
    }

    public static SimEvent scheduleAt(double time, int prio, Runnable method) {
        return SimContext.requireSimContext().scheduleAt(time, prio, method);
    }

    public static SimEvent scheduleAt(double time, Runnable method) {
        return SimContext.requireSimContext().scheduleAt(time, method);
    }

    public static SimEvent scheduleAt(String description, double time, int prio, Runnable action) {
        return SimContext.requireSimContext().scheduleAt(description, time, prio, action);
    }

    public static SimEvent scheduleAt(String description, double time, Runnable action) {
        return SimContext.requireSimContext().scheduleAt(description, time, action);
    }

    public static SimEvent scheduleAt(Instant time, int prio, Runnable method) {
        return SimContext.requireSimContext().scheduleAt(time, prio, method);
    }

    public static SimEvent scheduleAt(Instant time, Runnable method) {
        return SimContext.requireSimContext().scheduleAt(time, method);
    }

    public static SimEvent scheduleAt(String description, Instant time, int prio, Runnable method) {
        return SimContext.requireSimContext().scheduleAt(description, time, prio, method);
    }

    public static SimEvent scheduleAt(String description, Instant time, Runnable method) {
        return SimContext.requireSimContext().scheduleAt(description, time, method);
    }

    public static SimEvent scheduleIn(double time, int prio, Runnable method) {
        return SimContext.requireSimContext().scheduleIn(time, prio, method);
    }

    public static SimEvent scheduleIn(double time, Runnable method) {
        return SimContext.requireSimContext().scheduleIn(time, method);
    }

    public static SimEvent scheduleIn(String description, double time, int prio, Runnable method) {
        return SimContext.requireSimContext().scheduleIn(description, time, prio, method);
    }

    public static SimEvent scheduleIn(String description, double time, Runnable method) {
        return SimContext.requireSimContext().scheduleIn(description, time, method);
    }

    public static SimEvent scheduleIn(Duration duration, int prio, Runnable method) {
        return SimContext.requireSimContext().scheduleIn(duration, prio, method);
    }

    public static SimEvent scheduleIn(Duration duration, Runnable method) {
        return SimContext.requireSimContext().scheduleIn(duration, method);
    }

    public static SimEvent scheduleIn(String description, Duration duration, int prio, Runnable method) {
        return SimContext.requireSimContext().scheduleIn(description, duration, prio, method);
    }

    public static SimEvent scheduleIn(String description, Duration duration, Runnable method) {
        return SimContext.requireSimContext().scheduleIn(description, duration, method);
    }

    public static SimEvent scheduleIn(long numUnits, TemporalUnit unit, int prio, Runnable method) {
        return SimContext.requireSimContext().scheduleIn(numUnits, unit, prio, method);
    }

    public static SimEvent scheduleIn(long numUnits, TemporalUnit unit, Runnable method) {
        return SimContext.requireSimContext().scheduleIn(numUnits, unit, method);
    }

    public static SimEvent scheduleIn(String description, long numUnits, TemporalUnit unit, int prio, Runnable method) {
        return SimContext.requireSimContext().scheduleIn(description, numUnits, unit, prio, method);
    }

    public static SimEvent scheduleIn(String description, long numUnits, TemporalUnit unit, Runnable method) {
        return SimContext.requireSimContext().scheduleIn(description, numUnits, unit, method);
    }

    public static <T extends DblSequence> T initRndGen(T s, String streamName) {
        return SimContext.requireSimContext().initRndGen(s, streamName);
    }

    public static Map<String, Object> simulationOf(SimProcessUtil.SimRunnable r) {
        return SimContext.simulationOf(null, SimProcessUtil.simAction(r));
    }

    public static Map<String, Object> simulationOf(@Nullable String name, SimProcessUtil.SimRunnable r) {
        return SimContext.simulationOf(name, SimProcessUtil.simAction(r));
    }

    public static Map<String, Object> simulationOf(SimComponent ... components) {
        return SimContext.simulationOf(null, components);
    }

    public static Map<String, Object> simulationOf(@Nullable String name, SimComponent ... components) {
        return SimContext.simulationOf(name, (Simulation sim) -> sim.addComponent(components));
    }

    public static Map<String, Object> simulationOf(SimProcessUtil.SimAction a) {
        return SimContext.simulationOf(null, a);
    }

    public static Map<String, Object> simulationOf(@Nullable String name, SimProcessUtil.SimAction a) {
        Map<String, Object> res;
        if (SimContext.currentSimulation() != null) {
            Future<Map<String, Object>> resFuture = SimContext.async(name, a);
            try {
                res = resFuture.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new Simulation.SimulationFailed(SimContext.message(I18nConsts.NESTED_FAILED), e);
            }
            catch (ExecutionException e) {
                Throwable c = e.getCause();
                if (c instanceof RuntimeException) {
                    throw (RuntimeException)c;
                }
                throw new Simulation.SimulationFailed(SimContext.message(I18nConsts.NESTED_FAILED), c);
            }
        } else {
            Simulation sim = SimContext.createSim(name, a);
            res = sim.performRun();
        }
        return res;
    }

    public static Future<Map<String, Object>> async(SimProcessUtil.SimRunnable r) {
        return SimContext.async(null, SimProcessUtil.simAction(r));
    }

    public static Future<Map<String, Object>> async(@Nullable String name, SimProcessUtil.SimRunnable r) {
        return SimContext.async(name, SimProcessUtil.simAction(r));
    }

    public static Future<Map<String, Object>> async(SimProcessUtil.SimAction a) {
        return SimContext.async(null, a);
    }

    public static Future<Map<String, Object>> async(@Nullable String name, SimProcessUtil.SimAction a) {
        Simulation sim = SimContext.createSim(name, a);
        return sim.performRunAsync();
    }

    public static Simulation createSim(@Nullable String name, SimProcessUtil.SimAction a) {
        Simulation sim = new Simulation();
        sim.setName(name);
        sim.setMainProcessActions(a);
        return sim;
    }

    static void setThreadContext(Simulation sim) {
        if (sim != null && currentSim.get() != null && sim != currentSim.get()) {
            throw new IllegalStateException();
        }
        currentSim.set(sim);
    }

    static {
        I18n.requireResourceBundle("jasima.core.util.i18n.Messages", I18nConsts.class);
    }

    static enum I18nConsts {
        NO_CONTEXT,
        NESTED_FAILED;

    }
}

