/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation;

import jasima.core.simulation.SimComponent;
import jasima.core.util.observer.NotifierListener;
import java.util.Map;

public interface SimComponentLifecycleListener
extends NotifierListener<SimComponent, SimComponent.SimComponentEvent> {
    @Override
    default public void inform(SimComponent c, SimComponent.SimComponentEvent msg) {
        if (msg == SimComponent.SimComponentLifeCycleMessage.INIT) {
            this.init(c);
        } else if (msg == SimComponent.SimComponentLifeCycleMessage.SIM_START) {
            this.simStart(c);
        } else if (msg == SimComponent.SimComponentLifeCycleMessage.RESET_STATS) {
            this.resetStats(c);
        } else if (msg == SimComponent.SimComponentLifeCycleMessage.SIM_END) {
            this.simEnd(c);
        } else if (msg == SimComponent.SimComponentLifeCycleMessage.DONE) {
            this.done(c);
        } else if (msg instanceof SimComponent.ProduceResultsEvent) {
            SimComponent.ProduceResultsEvent pe = (SimComponent.ProduceResultsEvent)msg;
            this.produceResults(c, pe.resultMap);
        } else {
            this.handleOther(c, msg);
        }
    }

    default public void init(SimComponent c) {
    }

    default public void simStart(SimComponent c) {
    }

    default public void resetStats(SimComponent c) {
    }

    default public void simEnd(SimComponent c) {
    }

    default public void done(SimComponent c) {
    }

    default public void produceResults(SimComponent c, Map<String, Object> resultMap) {
    }

    default public void handleOther(SimComponent c, Object msg) {
    }

    @FunctionalInterface
    public static interface OtherListener
    extends SimComponentLifecycleListener {
        @Override
        public void handleOther(SimComponent var1, Object var2);
    }

    @FunctionalInterface
    public static interface ResultsListener
    extends SimComponentLifecycleListener {
        @Override
        public void produceResults(SimComponent var1, Map<String, Object> var2);
    }

    @FunctionalInterface
    public static interface DoneListener
    extends SimComponentLifecycleListener {
        @Override
        public void done(SimComponent var1);
    }

    @FunctionalInterface
    public static interface SimEndListener
    extends SimComponentLifecycleListener {
        @Override
        public void simEnd(SimComponent var1);
    }

    @FunctionalInterface
    public static interface ResetStatsListener
    extends SimComponentLifecycleListener {
        @Override
        public void resetStats(SimComponent var1);
    }

    @FunctionalInterface
    public static interface SimStartListener
    extends SimComponentLifecycleListener {
        @Override
        public void simStart(SimComponent var1);
    }

    @FunctionalInterface
    public static interface InitListener
    extends SimComponentLifecycleListener {
        @Override
        public void init(SimComponent var1);
    }
}

