/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation;

import jasima.core.simulation.SimComponent;
import jasima.core.simulation.SimComponentBase;
import jasima.core.simulation.SimComponentContainer;
import jasima.core.simulation.Simulation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class SimComponentContainerBase
extends SimComponentBase
implements SimComponentContainer {
    private List<SimComponent> components = new ArrayList<SimComponent>();
    private transient Map<String, SimComponent> componentsByName = null;

    public SimComponentContainerBase() {
        this(null, new SimComponent[0]);
    }

    public SimComponentContainerBase(String name, SimComponent ... children) {
        super(name);
        if (children != null && children.length > 0) {
            Stream.of(children).forEach(xva$0 -> this.addChild((SimComponent)xva$0));
        }
    }

    @Override
    public List<SimComponent> getChildren() {
        return Collections.unmodifiableList(this.components);
    }

    @Override
    public SimComponent getChild(int index) {
        return this.components.get(index);
    }

    @Override
    @Nullable
    public SimComponent getChildByName(String name) {
        if (this.componentsByName == null) {
            this.componentsByName = new HashMap<String, SimComponent>();
            this.components.forEach(c -> this.componentsByName.put(c.getName(), (SimComponent)c));
        }
        return name == null ? null : this.componentsByName.get(name);
    }

    @Override
    public SimComponentContainerBase addChild(SimComponent ... scs) {
        for (SimComponent sc : scs) {
            if (this.getChildByName(sc.getName()) != null) {
                throw new IllegalArgumentException(String.format("Container '%s' already contains a component '%s'.", this.getHierarchicalName(), sc.getName()));
            }
            this.componentsByName.put(sc.getName(), sc);
            this.components.add(sc);
            sc.setParent(this);
            sc.setSim(this.sim);
        }
        if (this.sim != null && this.sim.state() != Simulation.SimExecState.INITIAL && this.isInitialized()) {
            this.sim.activateComponents(scs);
        }
        return this;
    }

    @Override
    public void addComponent(SimComponent ... scs) {
        this.addChild(scs);
    }

    @Override
    public boolean removeChild(SimComponent sc) {
        boolean b = this.components.remove(sc);
        if (b) {
            sc.setParent(null);
        }
        return b;
    }

    @Override
    public void removeChildren() {
        this.components.forEach(c -> c.setParent(null));
        this.components.clear();
    }

    @Override
    public int numChildren() {
        return this.components.size();
    }

    @Override
    public SimComponentContainerBase clone() {
        SimComponentContainerBase clone = (SimComponentContainerBase)super.clone();
        clone.componentsByName = null;
        clone.components = new ArrayList<SimComponent>();
        for (int i = 0; i < this.numChildren(); ++i) {
            SimComponent c = this.getChild(i);
            clone.addChild(c.clone());
        }
        return clone;
    }
}

