/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation;

import jasima.core.simulation.SimComponent;
import jasima.core.util.StringUtil;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public interface SimComponentContainer
extends SimComponent {
    @Override
    @Nullable
    default public SimComponent getByHierarchicalName(String hierarchicalName) {
        String thisName;
        int endThisName = hierarchicalName.indexOf(46);
        if (endThisName >= 0) {
            thisName = hierarchicalName.substring(0, endThisName);
            hierarchicalName = hierarchicalName.substring(endThisName + 1);
        } else {
            thisName = hierarchicalName;
            hierarchicalName = "";
        }
        if (!StringUtil.equals(thisName, this.getName())) {
            return null;
        }
        if (hierarchicalName.length() == 0) {
            return this;
        }
        int childNameEnd = hierarchicalName.indexOf(46);
        String childName = childNameEnd >= 0 ? hierarchicalName.substring(0, childNameEnd) : hierarchicalName;
        SimComponent comp = this.getChildByName(childName);
        return comp != null ? comp.getByHierarchicalName(hierarchicalName) : null;
    }

    default public <T extends SimComponent> void componentSetHelper(T newValue, Supplier<T> getter, Consumer<T> setter) {
        SimComponent oldValue = (SimComponent)getter.get();
        if (oldValue != null) {
            this.removeChild(oldValue);
        }
        setter.accept(newValue);
        this.addChild(newValue);
    }

    @Override
    public SimComponentContainer clone();
}

