/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation;

import jasima.core.simulation.SimComponent;
import jasima.core.simulation.Simulation;
import jasima.core.util.TypeUtil;
import jasima.core.util.ValueStore;
import jasima.core.util.ValueStoreImpl;
import jasima.core.util.observer.NotifierImpl;
import javax.annotation.Nullable;

public class SimComponentBase
implements SimComponent {
    private transient SimComponent parent;
    private transient String hierarchicalName;
    protected transient Simulation sim;
    private transient boolean initialized = false;
    private String name;
    private NotifierImpl<SimComponent, SimComponent.SimComponentEvent> notifierAdapter;
    private ValueStoreImpl valueStore;

    public SimComponentBase() {
        this(null);
    }

    public SimComponentBase(String name) {
        if (name != null) {
            this.setName(name);
        }
    }

    @Override
    public Simulation getSim() {
        if (this.sim == null) {
            throw new IllegalStateException("no simulation.");
        }
        return this.sim;
    }

    @Override
    public void setSim(Simulation s) {
        this.sim = s;
    }

    @Override
    @Nullable
    public SimComponent getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@Nullable SimComponent parent) {
        this.hierarchicalName = null;
        this.parent = parent;
    }

    @Override
    public String getHierarchicalName() {
        if (this.hierarchicalName == null) {
            this.hierarchicalName = SimComponent.super.getHierarchicalName();
        }
        return this.hierarchicalName;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setInitialized(boolean initStatus) {
        this.initialized = initStatus;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SimComponent setName(String name) {
        if (!this.isValidName(name)) {
            throw new IllegalArgumentException(String.format("Component name '%s' is not valid.", name));
        }
        this.setNameInternal(name);
        return this;
    }

    protected void setNameInternal(String name) {
        this.hierarchicalName = null;
        this.name = name;
    }

    public String toString() {
        if (this.getName() == null) {
            return this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode());
        }
        return this.getName();
    }

    @Override
    public ValueStore valueStoreImpl() {
        if (this.valueStore == null) {
            this.valueStore = new ValueStoreImpl();
        }
        return this.valueStore;
    }

    @Override
    public NotifierImpl<SimComponent, SimComponent.SimComponentEvent> notifierImpl() {
        if (this.notifierAdapter == null) {
            this.notifierAdapter = new NotifierImpl(this);
        }
        return this.notifierAdapter;
    }

    @Override
    public SimComponentBase clone() {
        try {
            SimComponentBase c = (SimComponentBase)super.clone();
            if (this.valueStore != null) {
                c.valueStore = this.valueStore.clone();
            }
            if (this.notifierAdapter != null) {
                c.notifierAdapter = new NotifierImpl(c);
                for (int i = 0; i < this.numListener(); ++i) {
                    c.addListener(TypeUtil.cloneIfPossible(this.getListener(i)));
                }
            }
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

