/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation;

import jasima.core.simulation.SimComponentContainer;
import jasima.core.simulation.SimLifecycleListener;
import jasima.core.simulation.Simulation;
import jasima.core.simulation.util.SimOperations;
import jasima.core.util.StringUtil;
import jasima.core.util.ValueStore;
import jasima.core.util.observer.Notifier;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public interface SimComponent
extends Notifier<SimComponent, SimComponentEvent>,
SimLifecycleListener,
ValueStore,
Cloneable,
SimOperations {
    public static final char NAME_SEPARATOR = '.';

    @Override
    public Simulation getSim();

    public void setSim(Simulation var1);

    @Nullable
    public SimComponent getParent();

    public void setParent(@Nullable SimComponent var1);

    public String getName();

    public SimComponent setName(String var1);

    default public boolean isValidName(String name) {
        return name != null && name.length() > 0 && name.indexOf(46) < 0;
    }

    public boolean isInitialized();

    public void setInitialized(boolean var1);

    @Override
    default public void init() {
    }

    @Override
    default public void simStart() {
    }

    @Override
    default public void resetStats() {
    }

    @Override
    default public void simEnd() {
    }

    @Override
    default public void done() {
    }

    @Override
    default public void produceResults(Map<String, Object> res) {
    }

    @Override
    default public void handleOther(Simulation sim, Simulation.SimLifecycleEvent event) {
    }

    @Override
    default public void inform(Simulation sim, Simulation.SimLifecycleEvent event) {
        if (event == Simulation.StdSimLifecycleEvents.INIT) {
            if (this.isInitialized()) {
                throw new IllegalStateException("Component already initialized: " + this.toString());
            }
            this.fire(SimComponentLifeCycleMessage.INIT);
            this.init();
            this.setInitialized(true);
        } else if (event == Simulation.StdSimLifecycleEvents.SIM_START) {
            this.fire(SimComponentLifeCycleMessage.SIM_START);
            this.simStart();
        } else if (event == Simulation.StdSimLifecycleEvents.RESET_STATS) {
            this.fire(SimComponentLifeCycleMessage.RESET_STATS);
            this.resetStats();
        } else if (event == Simulation.StdSimLifecycleEvents.SIM_END) {
            this.fire(SimComponentLifeCycleMessage.SIM_END);
            this.simEnd();
        } else if (event == Simulation.StdSimLifecycleEvents.DONE) {
            this.fire(SimComponentLifeCycleMessage.DONE);
            this.done();
        } else if (event instanceof Simulation.ProduceResultsMessage) {
            Simulation.ProduceResultsMessage pe = (Simulation.ProduceResultsMessage)event;
            this.fire(new ProduceResultsEvent(pe.resultMap));
            this.produceResults(pe.resultMap);
        } else {
            this.handleOther(sim, event);
        }
        for (SimComponent c : this.getChildren()) {
            c.inform(sim, event);
        }
    }

    default public String getHierarchicalName() {
        StringBuilder sb = new StringBuilder();
        SimComponent p = this.getParent();
        if (p != null) {
            sb.append(p.getHierarchicalName()).append('.');
        }
        sb.append(this.toString());
        return sb.toString();
    }

    default public SimComponent getByHierarchicalName(String hierarchicalName) {
        return StringUtil.equals(hierarchicalName, this.getName()) ? this : null;
    }

    @Override
    default public void addComponent(SimComponent ... scs) {
        throw new UnsupportedOperationException("Can only add components to a container.");
    }

    default public List<SimComponent> getChildren() {
        return Collections.emptyList();
    }

    default public SimComponentContainer addChild(SimComponent ... scs) {
        throw new UnsupportedOperationException();
    }

    default public boolean removeChild(SimComponent sc) {
        return false;
    }

    default public boolean containsChild(SimComponent sc) {
        return sc.getParent() == this;
    }

    default public void removeChildren() {
    }

    default public int numChildren() {
        return 0;
    }

    default public SimComponent getChild(int index) {
        return this.getChildren().get(index);
    }

    @Nullable
    default public SimComponent getChildByName(String name) {
        return null;
    }

    @Override
    default public void addResult(String name, Object value) {
        String fullName = name.startsWith(".") ? this.getHierarchicalName() + name : name;
        SimOperations.super.addResult(fullName, value);
    }

    @Override
    public Notifier<SimComponent, SimComponentEvent> notifierImpl();

    @Override
    public ValueStore valueStoreImpl();

    public SimComponent clone();

    public static class ProduceResultsEvent
    implements SimComponentEvent {
        public final Map<String, Object> resultMap;

        public ProduceResultsEvent(Map<String, Object> resultMap) {
            this.resultMap = resultMap;
        }

        public String toString() {
            return "ProduceResultsEvent";
        }
    }

    public static enum SimComponentLifeCycleMessage implements SimComponentEvent
    {
        INIT,
        SIM_START,
        RESET_STATS,
        SIM_END,
        DONE;

    }

    public static interface SimComponentEvent {
    }
}

