/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.simulation;

import jasima.core.simulation.EventQueue;
import jasima.core.simulation.SimEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public final class EventHeap
implements EventQueue {
    private SimEvent[] nodes;
    private int count = 0;
    private boolean invalidRoot = false;

    public EventHeap() {
        this(103);
    }

    public EventHeap(int capacity) throws IllegalArgumentException {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.nodes = new SimEvent[capacity];
    }

    protected EventHeap(EventHeap copyFrom) {
        this(copyFrom.size() + 2);
        this.invalidRoot = copyFrom.invalidRoot;
        this.count = copyFrom.count;
        System.arraycopy(copyFrom.nodes, 0, this.nodes, 0, Math.min(this.count + 2, copyFrom.nodes.length));
    }

    @Override
    public void insert(SimEvent x) {
        if (this.count >= this.nodes.length) {
            this.setCapacity(3 * this.nodes.length / 2 + 1);
        }
        if (this.invalidRoot) {
            this.nodes[0] = x;
            ++this.count;
            this.invalidRoot = false;
            this.sink(this.nodes[0], 0);
        } else {
            this.bubbleUp(x, this.count);
            ++this.count;
        }
    }

    @Override
    public SimEvent extract() {
        SimEvent[] nodes = this.nodes;
        if (this.invalidRoot) {
            this.fixRootNode();
        }
        SimEvent least = nodes[0];
        nodes[0] = null;
        --this.count;
        this.invalidRoot = true;
        return least;
    }

    private void fixRootNode() {
        this.nodes[0] = this.nodes[this.count];
        this.nodes[this.count] = null;
        this.invalidRoot = false;
        this.sink(this.nodes[0], 0);
    }

    public int indexOf(SimEvent element) {
        Objects.requireNonNull(element);
        if (this.invalidRoot) {
            this.fixRootNode();
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.nodes[i] != element) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean remove(SimEvent element) {
        int idx = this.indexOf(element);
        if (idx < 0) {
            return false;
        }
        this.nodes[idx] = null;
        SimEvent e = this.nodes[this.count - 1];
        this.nodes[this.count - 1] = null;
        --this.count;
        if (e != null && this.bubbleUp(e, idx) == idx) {
            this.sink(e, idx);
        }
        return true;
    }

    public void clear() {
        Arrays.fill(this.nodes, 0, this.count, null);
        this.count = 0;
        this.invalidRoot = false;
    }

    @Override
    public int size() {
        return this.count;
    }

    public ArrayList<SimEvent> allEvents() {
        ArrayList<SimEvent> res = new ArrayList<SimEvent>();
        EventHeap copy = new EventHeap(this);
        for (int i = 0; i < this.count; ++i) {
            res.add(copy.extract());
        }
        return res;
    }

    private void setCapacity(int newCap) {
        if (newCap < this.count) {
            throw new IllegalArgumentException("Capacity has to be larger than count.");
        }
        SimEvent[] newnodes = new SimEvent[newCap];
        System.arraycopy(this.nodes, 0, newnodes, 0, this.count);
        this.nodes = newnodes;
    }

    private int bubbleUp(SimEvent x, int k) {
        int par;
        SimEvent[] nodes = this.nodes;
        while (k > 0 && x.compareTo(nodes[par = EventHeap.parent(k)]) < 0) {
            nodes[k] = nodes[par];
            k = par;
        }
        nodes[k] = x;
        return k;
    }

    private int sink(SimEvent x, int k) {
        int l;
        SimEvent[] nodes = this.nodes;
        int count = this.count;
        while ((l = EventHeap.left(k)) < count) {
            int child;
            int r = EventHeap.right(k);
            int n = child = r >= count || nodes[l].compareTo(nodes[r]) < 0 ? l : r;
            if (x.compareTo(nodes[child]) <= 0) break;
            nodes[k] = nodes[child];
            k = child;
        }
        nodes[k] = x;
        return k;
    }

    private static final int parent(int k) {
        return k - 1 >>> 1;
    }

    private static final int left(int k) {
        return (k << 1) + 1;
    }

    private static final int right(int k) {
        return (k << 1) + 2;
    }
}

