/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.run;

import jasima.core.experiment.AbstractMultiConfExperiment;
import jasima.core.experiment.Experiment;
import jasima.core.experiment.FullFactorialExperiment;
import jasima.core.util.TypeUtil;
import jasima.core.util.i18n.I18n;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jxl.BooleanCell;
import jxl.Cell;
import jxl.NumberCell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;

public class ExcelExperimentReader {
    private static final String COMMENT_PREFIX = "#";
    private static final String SHEET_CONFIGURATIONS = "configurations";
    private static final String SHEET_FACTORS = "factors";
    private static final String SHEET_MAIN = "jasima";
    private static final String SECT_MAIN = "jasima";
    private static final String SECT_CONFIGS = "configurations";
    private static final String SECT_FACTORS = "factors";
    private Sheet jasimaSheet;
    private Sheet cfgSheet;
    private Sheet factSheet;
    private int numConfigSections;
    private final ClassLoader classLoader;
    private final String[] packageSearchPath;
    private Experiment mainExp;
    private Map<String, List<Object>> factors;

    public ExcelExperimentReader(File file, ClassLoader loader, String[] packageSearchPath) {
        this.classLoader = loader;
        this.packageSearchPath = packageSearchPath;
        this.factSheet = null;
        this.cfgSheet = null;
        this.jasimaSheet = null;
        this.numConfigSections = 0;
        try {
            WorkbookSettings settings = new WorkbookSettings();
            settings.setSuppressWarnings(true);
            Workbook wbk = Workbook.getWorkbook((File)file, (WorkbookSettings)settings);
            for (String s : wbk.getSheetNames()) {
                if ("jasima".equalsIgnoreCase(s)) {
                    this.jasimaSheet = wbk.getSheet(s);
                    continue;
                }
                if ("factors".equalsIgnoreCase(s)) {
                    this.factSheet = wbk.getSheet(s);
                    continue;
                }
                if (!"configurations".equalsIgnoreCase(s)) continue;
                this.cfgSheet = wbk.getSheet(s);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (BiffException e) {
            throw new RuntimeException(e);
        }
        if (this.jasimaSheet == null) {
            throw new IllegalArgumentException("Can't find a sheet named 'jasima'");
        }
    }

    public Experiment createExperiment() {
        int row;
        this.parseMainSheet();
        this.jasimaSheet = null;
        if (this.cfgSheet != null) {
            row = this.parseCfgSection(this.cfgSheet, -1);
            if (row < this.cfgSheet.getRows()) {
                throw new RuntimeException("Unknown data on sheet 'configurations' after row " + (row + 1));
            }
            this.cfgSheet = null;
        }
        if (this.factSheet != null) {
            row = this.parseFactSection(this.factSheet, -1);
            if (row < this.factSheet.getRows()) {
                throw new RuntimeException("Unknown data on sheet 'factors' after row " + (row + 1));
            }
            this.factSheet = null;
        }
        if (this.factors != null) {
            FullFactorialExperiment ffe = new FullFactorialExperiment();
            ffe.setBaseExperiment(this.mainExp);
            for (Map.Entry<String, List<Object>> e : this.factors.entrySet()) {
                ffe.addFactor(e.getKey(), (Collection)e.getValue());
            }
            return ffe;
        }
        return this.mainExp;
    }

    private void parseMainSheet() {
        int row = -1;
        row = this.readMain(row);
        assert (this.mainExp != null);
        while ((row = ExcelExperimentReader.nextRowNonEmpty(this.jasimaSheet, row)) < this.jasimaSheet.getRows()) {
            Cell c = this.jasimaSheet.getCell(0, row);
            String s = String.valueOf(ExcelExperimentReader.getCellValue(c)).trim().toLowerCase(I18n.DEF_LOCALE);
            if (!this.isSectPrefix(s)) continue;
            if (s.startsWith("jasima")) {
                if (this.mainExp != null) {
                    throw new RuntimeException(I18n.defFormat("There can only be one section 'jasima' (cell %s).", ExcelExperimentReader.position(this.jasimaSheet, c)));
                }
            } else if (s.startsWith("factors")) {
                row = this.parseFactSection(this.jasimaSheet, row);
            } else if (s.startsWith("configurations")) {
                row = this.parseCfgSection(this.jasimaSheet, row);
            } else {
                throw new RuntimeException(String.format("Don't know how to handle section '%s'.", s));
            }
            if (row >= this.jasimaSheet.getRows()) continue;
            --row;
        }
        if (this.mainExp == null) {
            throw new RuntimeException("Could not find section starting with 'jasima'.");
        }
        assert (row >= this.jasimaSheet.getRows());
    }

    private int readMain(int row) {
        Cell c = this.jasimaSheet.getCell(0, row = ExcelExperimentReader.nextRowNonEmpty(this.jasimaSheet, row));
        String s = String.valueOf(ExcelExperimentReader.getCellValue(c)).trim();
        if (!"experiment".equalsIgnoreCase(s)) {
            throw new RuntimeException(I18n.defFormat("First value in section '%s' has to be 'experiment' (found '%s' in cell '%s').", "jasima", s, ExcelExperimentReader.position(this.jasimaSheet, c)));
        }
        c = this.jasimaSheet.getCell(1, row);
        Object o = ExcelExperimentReader.getCellValue(c);
        try {
            this.mainExp = TypeUtil.convert(o, Experiment.class, "", this.classLoader, this.packageSearchPath);
        }
        catch (TypeUtil.TypeConversionException t) {
            throw new RuntimeException(I18n.defFormat("There is a problem with cell '%s': %s", ExcelExperimentReader.position(this.jasimaSheet, c), t.getMessage()));
        }
        while ((row = ExcelExperimentReader.nextRowNonEmpty(this.jasimaSheet, row)) < this.jasimaSheet.getRows()) {
            c = this.jasimaSheet.getCell(0, row);
            String propName = String.valueOf(ExcelExperimentReader.getCellValue(c)).trim();
            if (this.isSectPrefix(propName)) {
                return row;
            }
            c = this.jasimaSheet.getCell(1, row);
            Object propValue = ExcelExperimentReader.getCellValue(c);
            try {
                TypeUtil.setPropertyValue(this.mainExp, propName, propValue, this.classLoader, this.packageSearchPath);
            }
            catch (RuntimeException t) {
                throw new RuntimeException(I18n.defFormat("There is a problem with cell '%s': %s", ExcelExperimentReader.position(this.jasimaSheet, c), t.getMessage()));
            }
        }
        return row;
    }

    private boolean isSectPrefix(String propName) {
        return (propName = propName.toLowerCase(I18n.DEF_LOCALE)).equals("jasima") || propName.equals("configurations") || propName.equals("factors");
    }

    private int parseFactSection(Sheet sheet, int row) {
        Cell c;
        String propName;
        if (this.mainExp == null) {
            throw new RuntimeException("Can't read factors without an experiment. Define it first in the 'jasima'-section on sheet 'jasima'.");
        }
        if ((row = ExcelExperimentReader.nextRowNonEmpty(sheet, row)) >= sheet.getRows()) {
            return row;
        }
        if (this.factors == null) {
            this.factors = new LinkedHashMap<String, List<Object>>();
        }
        ArrayList<String> propNames = new ArrayList<String>();
        ArrayList propValues = new ArrayList();
        for (int col = 0; col < sheet.getColumns() && (propName = String.valueOf(ExcelExperimentReader.getCellValue(c = sheet.getCell(col, row))).trim()).length() != 0; ++col) {
            ArrayList valueList = new ArrayList();
            propValues.add(valueList);
            propNames.add(propName);
            this.factors.put(propName, valueList);
        }
        while ((row = ExcelExperimentReader.nextRowNonEmpty(sheet, row)) < sheet.getRows()) {
            Cell c1 = sheet.getCell(0, row);
            Object v = ExcelExperimentReader.getCellValue(c1);
            if (v instanceof String && this.isSectPrefix((String)v)) {
                return row;
            }
            for (int col = 0; col < propValues.size(); ++col) {
                String s;
                Cell c2 = sheet.getCell(col, row);
                Object value = ExcelExperimentReader.getCellValue(c2);
                if (value instanceof String && (s = (String)value).length() == 0) continue;
                ((List)propValues.get(col)).add(new MultValueSetter(new String[]{(String)propNames.get(col)}, new Object[]{value}, sheet.getName(), row, col));
            }
        }
        return row;
    }

    private int parseCfgSection(Sheet sheet, int row) {
        Cell c;
        String s;
        if (this.mainExp == null) {
            throw new RuntimeException("Can't read configurations without an experiment. Define it first in the 'jasima'-section on sheet 'jasima'.");
        }
        if (this.factors == null) {
            this.factors = new LinkedHashMap<String, List<Object>>();
        }
        if ((row = ExcelExperimentReader.nextRowNonEmpty(sheet, row)) >= sheet.getRows()) {
            return row;
        }
        ArrayList<String> propNameList = new ArrayList<String>();
        for (int col = 0; col < sheet.getColumns() && (s = String.valueOf(ExcelExperimentReader.getCellValue(c = sheet.getCell(col, row))).trim()).length() != 0; ++col) {
            propNameList.add(s);
        }
        String[] propNames = propNameList.toArray(new String[propNameList.size()]);
        ArrayList<MultValueSetter> configurations = new ArrayList<MultValueSetter>();
        this.factors.put("@Conf" + ++this.numConfigSections, configurations);
        while ((row = ExcelExperimentReader.nextRowNonEmpty(sheet, row)) < sheet.getRows()) {
            Cell c1 = sheet.getCell(0, row);
            Object v = ExcelExperimentReader.getCellValue(c1);
            if (v instanceof String && this.isSectPrefix((String)v)) {
                return row;
            }
            ArrayList<Object> values = new ArrayList<Object>(propNames.length);
            for (int col = 0; col < propNames.length; ++col) {
                Cell c2 = sheet.getCell(col, row);
                Object value = ExcelExperimentReader.getCellValue(c2);
                values.add(value);
            }
            configurations.add(new MultValueSetter(propNames, values.toArray(), sheet.getName(), row, 0));
        }
        return row;
    }

    private static int nextRowNonEmpty(Sheet sheet, int row) {
        while (++row < sheet.getRows()) {
            Cell cell = sheet.getCell(0, row);
            Object v = ExcelExperimentReader.getCellValue(cell);
            if (v == null) continue;
            if (v instanceof String) {
                String s = (String)v;
                if ((s = s.trim()).length() <= 0 || s.startsWith(COMMENT_PREFIX)) continue;
                return row;
            }
            return row;
        }
        return row;
    }

    private static Object getCellValue(Cell c) {
        if (c instanceof BooleanCell) {
            return ((BooleanCell)c).getValue();
        }
        if (c instanceof NumberCell) {
            return ((NumberCell)c).getValue();
        }
        return c.getContents().trim();
    }

    private static String position(Sheet sheet, Cell c) {
        return ExcelExperimentReader.position(sheet.getName(), c.getRow(), c.getColumn());
    }

    private static String position(String sheetName, int row, int col) {
        String retVal = "";
        do {
            retVal = (char)(65 + col % 26) + retVal;
        } while ((col /= 26) > 0);
        retVal = retVal + (row + 1);
        return sheetName + "!" + retVal;
    }

    public class MultValueSetter
    implements AbstractMultiConfExperiment.ComplexFactorSetter {
        private static final long serialVersionUID = 5653125435835596532L;
        private final String[] propNames;
        private final Object[] propValues;
        private final String sheetName;
        private final int row;
        private final int col;

        public MultValueSetter(String[] propNames, Object[] propValues, String sheetName, int row, int col) {
            if (propNames.length != propValues.length) {
                throw new IllegalArgumentException(I18n.defFormat("Number of property names (%d) and values (%d) do not match.", propNames.length, propValues.length));
            }
            this.propNames = propNames;
            this.propValues = propValues;
            this.sheetName = sheetName;
            this.row = row;
            this.col = col;
        }

        @Override
        public void configureExperiment(Experiment e) {
            for (int i = 0; i < this.propNames.length; ++i) {
                String name = this.propNames[i];
                Object value = this.propValues[i];
                try {
                    TypeUtil.setPropertyValue(e, name, value, ExcelExperimentReader.this.classLoader, ExcelExperimentReader.this.packageSearchPath);
                    continue;
                }
                catch (RuntimeException t) {
                    throw new RuntimeException(I18n.defFormat("Problem with value in cell '%s': %s", ExcelExperimentReader.position(this.sheetName, this.row, this.col + i), t.getMessage()), t);
                }
            }
        }
    }
}

