/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.run;

import jasima.core.experiment.Experiment;
import jasima.core.experiment.ExperimentListener;
import jasima.core.run.AbstractExperimentRunner;
import jasima.core.run.ExcelExperimentReader;
import jasima.core.simulation.SimulationExperiment;
import jasima.core.util.ConsolePrinter;
import jasima.core.util.ExcelSaver;
import jasima.core.util.MsgCategory;
import jasima.core.util.Pair;
import jasima.core.util.StringUtil;
import jasima.core.util.TraceFileProducer;
import jasima.core.util.TypeUtil;
import jasima.core.util.Util;
import jasima.core.util.XmlSaver;
import jasima.core.util.i18n.I18n;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.util.KeyValuePair;

public class ConsoleRunner
extends AbstractExperimentRunner {
    private static final String DOTS = StringUtil.repeat("*", 80);
    private String expSpec;
    private Experiment expTemplate;
    private PropertyDescriptor[] beanProps;
    private boolean hideResults = false;

    public ConsoleRunner() {
        this(null);
    }

    public ConsoleRunner(@Nullable Experiment expTemplate) {
        this.expTemplate = expTemplate;
        if (expTemplate != null) {
            this.experimentFileName = expTemplate.getClass().getSimpleName();
        }
    }

    private void handleGenericOptions(OptionSet opts) {
        if (opts.has("help")) {
            this.printUsageAndExit();
        }
        if (opts.has("log")) {
            String vs = (String)opts.valueOf("log");
            MsgCategory cat = Enum.valueOf(MsgCategory.class, vs.toUpperCase(Locale.US));
            if (cat == MsgCategory.OFF) {
                this.listeners.remove(ConsolePrinter.class);
            } else {
                this.listeners.put(ConsolePrinter.class, new ConsolePrinter(cat));
            }
        }
        if (opts.has("trace")) {
            String traceFileName = (String)opts.valueOf("trace");
            final TraceFileProducer t = traceFileName == null ? new TraceFileProducer() : new TraceFileProducer(traceFileName);
            this.listeners.put(TraceFileProducer.class, new ExperimentListener(){

                @Override
                public void beforeRun(Experiment e) {
                    ExperimentListener.super.beforeRun(e);
                    SimulationExperiment se = (SimulationExperiment)e;
                    se.getSim().getRootComponent().addListener(t);
                }
            });
        }
        if (opts.has("nores")) {
            this.hideResults = true;
        }
        if (opts.has("xmlres")) {
            String xmlFileName = (String)opts.valueOf("xmlres");
            if (xmlFileName == null) {
                this.listeners.put(XmlSaver.class, new XmlSaver());
            } else {
                XmlSaver xs = new XmlSaver();
                xs.setResultFileName(xmlFileName);
                this.listeners.put(XmlSaver.class, xs);
            }
        }
        if (opts.has("xlsres")) {
            String xlsFileName = (String)opts.valueOf("xlsres");
            if (xlsFileName == null) {
                this.listeners.put(ExcelSaver.class, new ExcelSaver());
            } else {
                ExcelSaver es = new ExcelSaver();
                es.setResultFileName(xlsFileName);
                this.listeners.put(ExcelSaver.class, es);
            }
        }
        for (Object o : opts.valuesOf("D")) {
            String s = (String)o;
            KeyValuePair v = KeyValuePair.valueOf((String)s);
            this.manualProps.add(new Pair<String, String>(v.key, v.value));
        }
        for (Object o : opts.valuesOf("p")) {
            this.packageSearchPath = Util.addToArray(this.packageSearchPath, String.class, (String)o);
        }
    }

    private void handleExperimentOptions(OptionSet opts) {
        for (PropertyDescriptor prop : this.beanProps) {
            String name = prop.getName();
            if (!opts.has(name)) continue;
            String value = (String)opts.valueOf(name);
            this.manualProps.add(new Pair<String, String>(name, value));
        }
    }

    private void createGenericOptions(OptionParser p) {
        p.acceptsAll(Arrays.asList("h", "?", "help"), "Display this help text.").forHelp();
        MsgCategory[] values = MsgCategory.values();
        String logLevels = Arrays.toString((Object[])values).replaceAll("[\\[\\]]", "");
        p.acceptsAll(Arrays.asList("l", "log"), I18n.defFormat("Set log level to one of %s. Default: INFO.", logLevels)).withRequiredArg().describedAs("level");
        p.accepts("trace", "Produce a detailed event trace (only works for SimulationExperiments).").withOptionalArg().describedAs("filename");
        p.accepts("xmlres", "Save results in XML format.").withOptionalArg().describedAs("filename");
        p.accepts("xlsres", "Save results in Excel format.").withOptionalArg().describedAs("filename");
        p.accepts("nores", "Does not print results to console.");
        p.accepts("D", "Sets a property to a certain value.").withRequiredArg().describedAs("property=value");
        p.accepts("p", "Add an entry to the package search path.").withRequiredArg().describedAs("packageName");
    }

    private void createAdditionalOptions(OptionParser p) {
        Objects.requireNonNull(this.expToRun);
        for (PropertyDescriptor prop : this.beanProps = TypeUtil.findWritableProperties(this.expToRun)) {
            Class<?> type = prop.getPropertyType();
            String description = "";
            if (type.isEnum()) {
                String enumValues = Arrays.toString(type.getEnumConstants()).replaceAll("[\\[\\]]", "");
                description = I18n.defFormat("enum with values: %s", enumValues);
            } else if (type.isArray()) {
                Class<?> elemType = type.getComponentType();
                description = I18n.defFormat("array of '%s'", elemType.getSimpleName());
            } else if (!type.isPrimitive() && type != String.class) {
                description = I18n.defFormat("property of type '%s'", type.getSimpleName());
            }
            if (!"".equals(description)) {
                description = description + "; ";
            }
            description = description + "defined in class " + prop.getReadMethod().getDeclaringClass().getSimpleName();
            p.accepts(prop.getName(), description).withRequiredArg().describedAs(type.getSimpleName().toUpperCase());
        }
    }

    @Nullable
    private Experiment createExperiment() {
        Experiment e;
        if (this.expTemplate == null && this.expSpec == null) {
            return null;
        }
        if (this.expTemplate != null) {
            e = this.expTemplate;
        } else if (this.expSpec.toLowerCase(I18n.DEF_LOCALE).endsWith(".xls")) {
            this.experimentFileName = this.expSpec;
            e = new ExcelExperimentReader(new File(this.experimentFileName), this.getClass().getClassLoader(), this.packageSearchPath).createExperiment();
        } else {
            e = TypeUtil.convert(this.expSpec, Experiment.class, "", this.getClass().getClassLoader(), this.packageSearchPath);
        }
        return e;
    }

    public Map<String, Object> runWith(String ... args) {
        if (this.expTemplate == null && args.length > 0 && !args[0].startsWith("-")) {
            this.expSpec = args[0];
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        try {
            this.expToRun = null;
            try {
                this.expToRun = this.createExperiment();
            }
            finally {
                ConsoleRunner.printBanner(this.expToRun);
            }
            this.parseArgs(args);
            if (this.expToRun == null) {
                if (this.expTemplate == null && this.expSpec == null) {
                    this.printErrorThenExit(1, "No valid experiment file name/class name given.", new Object[0]);
                } else {
                    this.printErrorThenExit(1, "Couldn't load experiment using: '%s'", this.expSpec);
                }
                throw new AssertionError();
            }
            this.configureExperiment();
        }
        catch (Exception e) {
            this.printErrorThenExit(1, "Problem configuring experiment: %s (%s)", e.getLocalizedMessage(), Util.exceptionToString(e));
            throw new AssertionError();
        }
        try {
            Map<String, Object> res = this.run();
            if (!this.hideResults) {
                ConsolePrinter.printResults(this.expToRun, res);
            }
            return res;
        }
        catch (Exception e) {
            this.printErrorThenExit(2, "Unhandled exception during run: %s (%s)", e.getLocalizedMessage(), Util.exceptionToString(e));
            throw new AssertionError();
        }
    }

    private void parseArgs(String[] args) {
        ArrayList remainingArgs;
        OptionParser optsParser = new OptionParser();
        optsParser.allowsUnrecognizedOptions();
        this.createGenericOptions(optsParser);
        if (this.expToRun != null) {
            this.createAdditionalOptions(optsParser);
        }
        OptionSet opts = optsParser.parse(args);
        this.handleGenericOptions(opts);
        if (this.expToRun != null) {
            this.handleExperimentOptions(opts);
        }
        if ((remainingArgs = new ArrayList(opts.nonOptionArguments())).size() > 0) {
            throw new RuntimeException(I18n.defFormat("unrecognized command line parameters: %s", Arrays.toString(remainingArgs.toArray())));
        }
    }

    void exit(int errorCode) {
        System.exit(errorCode);
    }

    private void printErrorThenExit(int errorCode, String format, Object ... args) {
        System.err.printf(format, args);
        System.err.println();
        System.err.println();
        System.err.println("Run with parameter --help for valid command line parameters.");
        if (errorCode != 0) {
            this.exit(errorCode);
        }
    }

    public static void printBanner(Experiment exp) {
        PrintWriter pw = new PrintWriter(System.out, true);
        try {
            ConsoleRunner.printBanner(pw, exp);
        }
        finally {
            pw.flush();
        }
    }

    public static void printBanner(PrintWriter out, Experiment exp) {
        out.println(DOTS);
        out.println(Util.getIdString());
        out.println();
        if (exp != null) {
            out.println(exp.getClass().getSimpleName() + ": " + exp.toString());
            out.println();
        }
        out.println(Util.getJavaEnvString());
        out.println(Util.getOsEnvString());
        out.println(Util.getWorkingDirString());
        out.println(DOTS);
        out.println();
    }

    private void printUsageAndExit() {
        try {
            System.err.println(this.getHelpCmdLineText());
            System.err.println();
            System.err.println(Util.getIdString());
            if (this.expToRun != null) {
                OptionParser op2 = new OptionParser();
                this.createAdditionalOptions(op2);
                System.err.println();
                System.err.println("Experiment properties (top-level):");
                System.err.println("==================================");
                op2.printHelpOn((OutputStream)System.err);
            } else {
                System.err.println();
                System.err.println("(no experiment options available)");
            }
            System.err.println();
            System.err.println("Generic options:");
            System.err.println("================");
            OptionParser op1 = new OptionParser();
            this.createGenericOptions(op1);
            op1.printHelpOn((OutputStream)System.err);
            System.err.println(this.getHelpFooterText());
        }
        catch (IOException iOException) {
        }
        finally {
            this.exit(0);
        }
    }

    private String getHelpCmdLineText() {
        if (this.expTemplate != null) {
            return "usage: " + this.expTemplate.getClass().getName() + " [options]";
        }
        return "usage: " + this.getClass().getName() + " <expSpec> [options]";
    }

    private String getHelpFooterText() {
        String res = System.lineSeparator() + "All parameter names are CASE-SENSITIVE. For detailed information see " + System.lineSeparator() + "http://jasima.net/.";
        if (this.expTemplate == null) {
            res = "<expSpec>                    Class name of an Experiment or file name " + System.lineSeparator() + "                             of an XML-serialized Experiment or" + System.lineSeparator() + "                             name of an xls file." + System.lineSeparator() + res;
        }
        return res;
    }

    public static Map<String, Object> run(@Nullable Experiment template, String ... args) {
        ConsoleRunner cr = new ConsoleRunner(template);
        return cr.runWith(args);
    }

    public static Map<String, Object> run(String ... args) {
        return ConsoleRunner.run(null, args);
    }

    public static void main(String ... args) {
        ConsoleRunner.run(args);
    }
}

