/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.run;

import jasima.core.experiment.Experiment;
import jasima.core.experiment.ExperimentListener;
import jasima.core.util.AbstractResultSaver;
import jasima.core.util.ConsolePrinter;
import jasima.core.util.MsgCategory;
import jasima.core.util.Pair;
import jasima.core.util.TypeUtil;
import jasima.core.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public abstract class AbstractExperimentRunner {
    protected Map<Object, ExperimentListener> listeners;
    protected String experimentFileName = null;
    protected String[] packageSearchPath = Util.DEF_CLASS_SEARCH_PATH;
    protected ArrayList<Pair<String, Object>> manualProps;
    protected Experiment expToRun = null;

    public AbstractExperimentRunner() {
        this.listeners = new HashMap<Object, ExperimentListener>();
        this.listeners.put(ConsolePrinter.class, new ConsolePrinter(MsgCategory.INFO));
        this.manualProps = new ArrayList();
    }

    protected void configureExperiment() {
        Objects.requireNonNull(this.expToRun);
        String resultFileNameHint = this.getResultFileNameHint();
        for (ExperimentListener lstnr : this.listeners.values()) {
            if (resultFileNameHint != null && lstnr instanceof AbstractResultSaver) {
                ((AbstractResultSaver)lstnr).setFileNameHint(resultFileNameHint);
            }
            this.expToRun.addListener(lstnr);
        }
        this.setProperties();
    }

    @Nullable
    public Map<String, Object> run() {
        Objects.requireNonNull(this.expToRun);
        return this.expToRun.runExperiment();
    }

    private void setProperties() {
        Objects.requireNonNull(this.expToRun);
        Collections.sort(this.manualProps, Comparator.comparingInt(p -> AbstractExperimentRunner.numSegments((String)p.a)));
        for (Pair<String, Object> p2 : this.manualProps) {
            String name = (String)p2.a;
            Object value = p2.b;
            TypeUtil.setPropertyValue(this.expToRun, name, value, this.getClass().getClassLoader(), this.packageSearchPath);
        }
    }

    protected String getResultFileNameHint() {
        return this.experimentFileName;
    }

    private static int numSegments(String a) {
        if (a == null || a.length() == 0) {
            return 0;
        }
        int res = 1;
        int from = -1;
        while ((from = a.indexOf(46, from + 1)) >= 0) {
            ++res;
        }
        return res;
    }
}

