/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.random.discrete;

import jasima.core.random.discrete.IntSequence;
import jasima.core.util.Pair;
import java.util.Random;

public class IntUniformRange
extends IntSequence {
    private static final long serialVersionUID = -7138352768070870971L;
    private int min;
    private int max;
    private int range;

    public IntUniformRange(int min, int max) {
        this(null, null, min, max);
    }

    public IntUniformRange(Random random, int min, int max) {
        this(random, null, min, max);
    }

    public IntUniformRange(String name, int min, int max) {
        this(null, name, min, max);
    }

    public IntUniformRange(Random random, String name, int min, int max) {
        this.setRange(min, max);
        this.setRndGen(random);
        this.setName(name);
    }

    @Override
    public void init() {
        super.init();
        this.setRange(this.min, this.max);
    }

    @Override
    public Pair<Double, Double> getValueRange() {
        return new Pair<Double, Double>(Double.valueOf(this.getMin()), Double.valueOf(this.getMax()));
    }

    public void setRange(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("min<max " + min + " " + max);
        }
        long r = max - min;
        if (r > 0x7FFFFFFEL || r < 0L) {
            throw new IllegalArgumentException("range has to fit in an integer. " + min + " " + max);
        }
        this.setMin(min);
        this.setMax(max);
        this.range = (int)r;
    }

    @Override
    public int nextInt() {
        return this.getMin() + this.rndGen.nextInt(this.range + 1);
    }

    @Override
    public double getNumericalMean() {
        return (double)((long)this.getMin() + (long)this.getMax()) / 2.0;
    }

    public String toString() {
        return "IntUniformRange(min=" + this.getMin() + ";max=" + this.getMax() + ")";
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }
}

