/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.random.discrete;

import jasima.core.random.discrete.IntDistribution;
import jasima.core.util.i18n.I18n;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.PoissonDistribution;
import org.apache.commons.math3.exception.NotPositiveException;

public class IntPoisson
extends IntDistribution {
    private static final long serialVersionUID = -3018032705267062035L;
    private PoissonDistribution dist;

    public IntPoisson() {
        this(1.0);
    }

    public IntPoisson(double mean) {
        this.setDistribution((IntegerDistribution)new PoissonDistribution(mean));
    }

    @Override
    protected void setDistribution(IntegerDistribution distribution) {
        this.dist = (PoissonDistribution)distribution;
        super.setDistribution(distribution);
    }

    @Override
    public String toString() {
        return I18n.defFormat("IntPoisson(mean=%f)", this.getMean());
    }

    public double getMean() {
        return this.dist.getMean();
    }

    public void setMean(double mean) throws NotPositiveException {
        this.setDistribution((IntegerDistribution)new PoissonDistribution(mean));
    }
}

