/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.random.discrete;

import jasima.core.random.discrete.IntDistribution;
import jasima.core.util.i18n.I18n;
import org.apache.commons.math3.distribution.HypergeometricDistribution;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;

public class IntHypergeometric
extends IntDistribution {
    private static final long serialVersionUID = 7866375360611450226L;
    private HypergeometricDistribution dist;

    public IntHypergeometric() {
        this(20, 10, 5);
    }

    public IntHypergeometric(int populationSize, int numberOfSuccesses, int sampleSize) {
        this.setDistribution((IntegerDistribution)new HypergeometricDistribution(populationSize, numberOfSuccesses, sampleSize));
    }

    @Override
    protected void setDistribution(IntegerDistribution distribution) {
        this.dist = (HypergeometricDistribution)distribution;
        super.setDistribution(distribution);
    }

    @Override
    public String toString() {
        return I18n.defFormat("IntHypergeometric(populationSize=%d;numberOfSuccesses=%d;sampleSize=%d)", this.getPopulationSize(), this.getNumberOfSuccesses(), this.getSampleSize());
    }

    public int getPopulationSize() {
        return this.dist.getPopulationSize();
    }

    public void setPopulationSize(int populationSize) throws NotStrictlyPositiveException {
        this.setDistribution((IntegerDistribution)new HypergeometricDistribution(populationSize, this.dist.getNumberOfSuccesses(), this.dist.getSampleSize()));
    }

    public int getNumberOfSuccesses() {
        return this.dist.getNumberOfSuccesses();
    }

    public void setNumberOfSuccesses(int numberOfSuccesses) throws NumberIsTooLargeException {
        this.setDistribution((IntegerDistribution)new HypergeometricDistribution(this.dist.getPopulationSize(), numberOfSuccesses, this.dist.getSampleSize()));
    }

    public int getSampleSize() {
        return this.dist.getSampleSize();
    }

    public void setSampleSize(int sampleSize) throws NumberIsTooLargeException {
        this.setDistribution((IntegerDistribution)new HypergeometricDistribution(this.dist.getPopulationSize(), this.dist.getNumberOfSuccesses(), sampleSize));
    }
}

