/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.random.discrete;

import jasima.core.random.discrete.IntSequence;
import jasima.core.util.Pair;
import jasima.core.util.Util;
import jasima.core.util.i18n.I18n;
import java.util.Arrays;
import java.util.Random;

public class IntEmpirical
extends IntSequence {
    private static final long serialVersionUID = -8591371451392742035L;
    private double[] probs = null;
    private int[] vals = null;
    private Double mean = null;

    public IntEmpirical() {
        this(null, null, null, null);
    }

    public IntEmpirical(double[] probs) {
        this(null, null, probs, null);
    }

    public IntEmpirical(Random rnd, double[] probs) {
        this(rnd, null, probs, null);
    }

    public IntEmpirical(String name, double[] probs) {
        this(null, name, probs, null);
    }

    public IntEmpirical(double[] probs, int[] values) {
        this(null, null, probs, values);
    }

    public IntEmpirical(Random rnd, double[] probs, int[] values) {
        this(rnd, null, probs, values);
    }

    public IntEmpirical(String name, double[] probs, int[] values) {
        this(null, name, probs, values);
    }

    public IntEmpirical(Random rnd, String name, double[] probs, int[] values) {
        this.setProbabilities(probs, values);
        this.setRndGen(rnd);
        this.setName(name);
    }

    public double[] getProbabilities() {
        return this.probs;
    }

    public void setProbabilities(double[] probs) {
        this.setProbabilities(probs, null);
    }

    public int[] getValues() {
        return this.vals;
    }

    public void setValues(int[] vs) {
        this.vals = vs;
    }

    @Override
    public int nextInt() {
        double prob = this.rndGen.nextDouble();
        int n = -1;
        double d = 0.0;
        for (int i = 0; i < this.probs.length; ++i) {
            if (!((d += this.probs[i]) > prob)) continue;
            n = i;
            break;
        }
        assert (n >= 0);
        return this.vals != null ? this.vals[n] : n;
    }

    public void setProbabilities(double[] probs, int[] values) {
        if (probs != null && Math.abs(Util.sum(probs) - 1.0) > 1.0E-6) {
            throw new IllegalArgumentException("probabilities must add to 1: " + Arrays.toString(probs) + " " + Util.sum(probs));
        }
        if (values != null && values.length != probs.length) {
            throw new IllegalArgumentException("There has to be a value for each probability.");
        }
        this.probs = probs;
        this.vals = values;
        this.mean = null;
    }

    @Override
    public double getNumericalMean() {
        if (this.mean == null) {
            if (this.probs == null || this.probs.length == 0) {
                this.mean = Double.NaN;
            } else {
                this.mean = 0.0;
                for (int i = 0; i < this.probs.length; ++i) {
                    int value = this.vals == null ? i : this.vals[i];
                    this.mean = this.mean + this.probs[i] * (double)value;
                }
            }
        }
        return this.mean;
    }

    @Override
    public IntEmpirical clone() {
        IntEmpirical c = (IntEmpirical)super.clone();
        if (this.probs != null) {
            c.probs = (double[])this.probs.clone();
        }
        if (this.vals != null) {
            c.vals = (int[])this.vals.clone();
        }
        return c;
    }

    public String toString() {
        String params = "";
        StringBuilder sb = new StringBuilder();
        int n = this.probs != null ? this.probs.length : 0;
        int m = this.vals != null ? this.vals.length : 0;
        for (int i = 0; i < Math.max(n, m); ++i) {
            String v = this.vals != null && i < this.vals.length ? Integer.toString(this.vals[i]) : "?";
            String p = this.probs != null && i < this.probs.length ? Double.toString(this.probs[i]) : "?";
            sb.append('<').append(v).append(',').append(p).append(">;");
        }
        if (sb.length() > 0) {
            params = sb.substring(0, sb.length() - 1);
        }
        return I18n.defFormat("%s(%s)", this.getClass().getSimpleName(), params);
    }

    @Override
    public Pair<Double, Double> getValueRange() {
        int max;
        int min;
        if (this.vals != null) {
            min = Util.min(this.vals);
            max = Util.max(this.vals);
        } else {
            min = 0;
            max = this.probs.length;
        }
        return new Pair<Double, Double>(Double.valueOf(min), Double.valueOf(max));
    }
}

