/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.random.discrete;

import jasima.core.random.discrete.IntSequence;
import jasima.core.util.Pair;
import org.apache.commons.math3.distribution.IntegerDistribution;

public class IntDistribution
extends IntSequence {
    private static final long serialVersionUID = -2911819386618158493L;
    private IntegerDistribution distribution;

    public IntDistribution() {
        this(null);
    }

    public IntDistribution(IntegerDistribution distribution) {
        this.setDistribution(distribution);
    }

    public IntegerDistribution getDistribution() {
        return this.distribution;
    }

    protected void setDistribution(IntegerDistribution distribution) {
        this.distribution = distribution;
    }

    @Override
    public int nextInt() {
        return this.distribution.inverseCumulativeProbability(this.rndGen.nextDouble());
    }

    @Override
    public double getNumericalMean() {
        if (this.distribution == null) {
            return Double.NaN;
        }
        return this.distribution.getNumericalMean();
    }

    @Override
    public Pair<Double, Double> getValueRange() {
        if (this.distribution == null) {
            return null;
        }
        double min = this.distribution.getSupportLowerBound();
        double max = this.distribution.getSupportUpperBound();
        return new Pair<Double, Double>(min, max);
    }

    public String toString() {
        return "IntDistribution(" + String.valueOf(this.distribution) + ')';
    }
}

