/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.random.discrete;

import jasima.core.random.continuous.DblSequence;
import jasima.core.random.discrete.IntSequence;
import jasima.core.util.Pair;
import java.util.Random;

public class IntDiscretized
extends IntSequence {
    private static final long serialVersionUID = -5846263470745133816L;
    private DblSequence baseStream;

    public IntDiscretized() {
        this(null);
    }

    public IntDiscretized(DblSequence baseStream) {
        this.setBaseStream(baseStream);
    }

    @Override
    public void init() {
        super.init();
        if (this.baseStream != null) {
            this.baseStream.init();
        }
    }

    @Override
    public int nextInt() {
        return IntDiscretized.roundToClosestInt(this.baseStream.nextDbl());
    }

    @Override
    public double getNumericalMean() {
        return IntDiscretized.roundToClosestInt(this.baseStream.nextDbl());
    }

    @Override
    public Pair<Double, Double> getValueRange() {
        Pair<Double, Double> r = this.baseStream.getValueRange();
        return new Pair<Double, Double>(Double.valueOf(IntDiscretized.roundToClosestInt((Double)r.a)), Double.valueOf(IntDiscretized.roundToClosestInt((Double)r.b)));
    }

    @Override
    public void setRndGen(Random rndGen) {
        super.setRndGen(rndGen);
        if (this.baseStream != null) {
            this.baseStream.setRndGen(rndGen);
        }
    }

    private static int roundToClosestInt(double v) {
        return (int)Math.round(v);
    }

    @Override
    public IntDiscretized clone() {
        IntDiscretized c = (IntDiscretized)super.clone();
        if (this.baseStream != null) {
            c.baseStream = this.baseStream.clone();
        }
        return c;
    }

    public String toString() {
        return "IntDiscretized(baseStream=" + String.valueOf(this.getBaseStream()) + ")";
    }

    public DblSequence getBaseStream() {
        return this.baseStream;
    }

    public void setBaseStream(DblSequence baseStream) {
        this.baseStream = baseStream;
        if (this.getRndGen() != null) {
            baseStream.setRndGen(this.getRndGen());
        }
    }
}

