/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.random.discrete;

import jasima.core.random.discrete.IntSequence;
import jasima.core.util.Pair;
import jasima.core.util.Util;
import java.util.Arrays;

public class IntConst
extends IntSequence {
    private static final long serialVersionUID = -3297743869123820992L;
    private int[] values;
    private boolean randomizeOrder;
    private Double mean;
    private int next = Integer.MAX_VALUE;
    private int[] valuesRnd;

    public IntConst() {
        this(null);
    }

    public IntConst(int ... vs) {
        this.setValues(vs);
    }

    private void nextIteration() {
        this.next = 0;
        if (this.isRandomizeOrder()) {
            Util.shuffle(this.valuesRnd, this.rndGen);
        }
    }

    @Override
    public int nextInt() {
        if (this.next >= this.valuesRnd.length) {
            this.nextIteration();
        }
        int v = this.valuesRnd[this.next];
        ++this.next;
        return v;
    }

    @Override
    public double getNumericalMean() {
        if (this.mean == null) {
            this.mean = this.values == null || this.values.length == 0 ? Double.valueOf(Double.NaN) : Double.valueOf((double)Util.sum(this.values) / (double)this.values.length);
        }
        return this.mean;
    }

    @Override
    public Pair<Double, Double> getValueRange() {
        if (this.values == null || this.values.length == 0) {
            return new Pair<Double, Double>(Double.NaN, Double.NaN);
        }
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (int d : this.values) {
            if (d < min) {
                min = d;
            }
            if (d <= max) continue;
            max = d;
        }
        return new Pair<Double, Double>(Double.valueOf(min), Double.valueOf(max));
    }

    public String toString() {
        return "IntConst" + Arrays.toString(this.values);
    }

    @Override
    public IntConst clone() {
        IntConst c = (IntConst)super.clone();
        if (this.values != null) {
            c.values = (int[])this.values.clone();
        }
        if (this.valuesRnd != null) {
            c.valuesRnd = (int[])this.valuesRnd.clone();
        }
        return c;
    }

    public int[] getValues() {
        return this.values;
    }

    public void setValues(int ... vs) {
        this.mean = null;
        if (vs == null) {
            this.values = null;
            this.valuesRnd = null;
        } else {
            this.values = (int[])vs.clone();
            this.valuesRnd = (int[])vs.clone();
        }
    }

    public boolean isRandomizeOrder() {
        return this.randomizeOrder;
    }

    public void setRandomizeOrder(boolean randomizeOrder) {
        this.randomizeOrder = randomizeOrder;
    }
}

