/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.random.discrete;

import jasima.core.random.discrete.IntDistribution;
import jasima.core.util.i18n.I18n;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.OutOfRangeException;

public class IntBinomial
extends IntDistribution {
    private static final long serialVersionUID = 485349306562793350L;
    private BinomialDistribution dist;

    public IntBinomial() {
        this(20, 0.5);
    }

    public IntBinomial(int n, double p) {
        this.setDistribution((IntegerDistribution)new BinomialDistribution(n, p));
    }

    @Override
    protected void setDistribution(IntegerDistribution distribution) {
        this.dist = (BinomialDistribution)distribution;
        super.setDistribution(distribution);
    }

    @Override
    public String toString() {
        return I18n.defFormat("IntBinomial(probabilityOfSuccess=%f;numTrials=%d)", this.getProbabilityOfSuccess(), this.getNumTrials());
    }

    public double getProbabilityOfSuccess() {
        return this.dist.getProbabilityOfSuccess();
    }

    public void setProbabilityOfSuccess(double probOfSuccess) throws OutOfRangeException {
        this.setDistribution((IntegerDistribution)new BinomialDistribution(this.dist.getNumberOfTrials(), probOfSuccess));
    }

    public int getNumTrials() {
        return this.dist.getNumberOfTrials();
    }

    public void setNumTrials(int numTrials) throws NotPositiveException {
        this.setDistribution((IntegerDistribution)new BinomialDistribution(numTrials, this.dist.getProbabilityOfSuccess()));
    }
}

