/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.random.discrete;

import jasima.core.random.discrete.IntSequence;
import jasima.core.util.Pair;
import jasima.core.util.i18n.I18n;
import org.apache.commons.math3.exception.OutOfRangeException;

public class IntBernoulli
extends IntSequence {
    private static final long serialVersionUID = 1515307949822420310L;
    private double probabilityOfSuccess;

    public IntBernoulli() {
        this(0.5);
    }

    public IntBernoulli(double probabilityOfSuccess) {
        this.setProbabilityOfSuccess(probabilityOfSuccess);
    }

    @Override
    public int nextInt() {
        return this.rndGen.nextDouble() < this.probabilityOfSuccess ? 1 : 0;
    }

    @Override
    public double getNumericalMean() {
        return this.probabilityOfSuccess;
    }

    @Override
    public Pair<Double, Double> getValueRange() {
        return new Pair<Double, Double>(0.0, 1.0);
    }

    public String toString() {
        return I18n.defFormat("IntBernoulli(probabilityOfSuccess=%f)", this.getProbabilityOfSuccess());
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    public void setProbabilityOfSuccess(double probOfSuccess) throws OutOfRangeException {
        if (probOfSuccess < 0.0 || probOfSuccess > 1.0) {
            throw new OutOfRangeException((Number)probOfSuccess, (Number)0, (Number)1);
        }
        this.probabilityOfSuccess = probOfSuccess;
    }
}

