/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.random.continuous;

import jasima.core.random.continuous.DblDistribution;
import jasima.core.util.i18n.I18n;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.WeibullDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;

public class DblWeibull
extends DblDistribution {
    private static final long serialVersionUID = 2252634635785170819L;
    private WeibullDistribution dist;

    public DblWeibull() {
        this(1.0, 1.5);
    }

    public DblWeibull(double shape, double scale) {
        this.setDistribution((RealDistribution)new WeibullDistribution(shape, scale));
    }

    @Override
    protected void setDistribution(RealDistribution distribution) {
        this.dist = (WeibullDistribution)distribution;
        super.setDistribution(distribution);
    }

    @Override
    public String toString() {
        return I18n.defFormat("DblWeibull(shape=%f;scale=%f)", this.getShape(), this.getScale());
    }

    public double getShape() {
        return this.dist.getShape();
    }

    public void setShape(double shape) throws NotStrictlyPositiveException {
        this.setDistribution((RealDistribution)new WeibullDistribution(shape, this.dist.getScale()));
    }

    public double getScale() {
        return this.dist.getScale();
    }

    public void setScale(double scale) {
        this.setDistribution((RealDistribution)new WeibullDistribution(this.dist.getShape(), scale));
    }
}

