/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.random.continuous;

import jasima.core.random.continuous.DblSequence;
import jasima.core.util.Pair;
import jasima.core.util.i18n.I18n;
import java.util.Random;

public class DblUniformRange
extends DblSequence {
    private static final long serialVersionUID = 7183118564770349548L;
    private double min = 0.0;
    private double max = 1.0;
    private double range = 1.0;

    public DblUniformRange(double min, double max) {
        this(null, null, min, max);
    }

    public DblUniformRange(Random random, double min, double max) {
        this(random, null, min, max);
    }

    public DblUniformRange(String name, double min, double max) {
        this(null, name, min, max);
    }

    public DblUniformRange(Random random, String name, double min, double max) {
        this.setRange(min, max);
        this.setRndGen(random);
        this.setName(name);
    }

    public void setRange(double min, double max) {
        this.checkValues(min, max);
        this.min = min;
        this.max = max;
    }

    @Override
    public void init() {
        this.checkValues(this.min, this.max);
        super.init();
        this.range = this.max - this.min;
    }

    @Override
    public double nextDbl() {
        return this.min + this.range * this.rndGen.nextDouble();
    }

    @Override
    public double getNumericalMean() {
        return (this.getMin() + this.getMax()) / 2.0;
    }

    public String toString() {
        return I18n.defFormat("DblUniformRange(min=%f;max=%f)", this.min, this.max);
    }

    @Override
    public Pair<Double, Double> getValueRange() {
        return new Pair<Double, Double>(this.getMin(), this.getMax());
    }

    private void checkValues(double min, double max) {
        if (!(min < max)) {
            throw new IllegalArgumentException("min>max " + min + " " + max);
        }
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }
}

