/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.random.continuous;

import jasima.core.random.continuous.DblSequence;
import jasima.core.util.Pair;
import jasima.core.util.i18n.I18n;

public class DblTruncatedSimple
extends DblSequence {
    private static final long serialVersionUID = -3224445720493038341L;
    private DblSequence baseStream;
    private double minValue;
    private double maxValue;

    public DblTruncatedSimple() {
        this(null, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public DblTruncatedSimple(DblSequence baseStream, double min, double max) {
        this.setBaseStream(baseStream);
        this.setMinValue(min);
        this.setMaxValue(max);
    }

    @Override
    public void init() {
        if (!DblTruncatedSimple.isValidRange(this.getMinValue(), this.getMaxValue())) {
            throw new IllegalArgumentException();
        }
        super.init();
        if (this.baseStream.getRndGen() == null) {
            this.baseStream.setRndGen(this.getRndGen());
        }
        this.baseStream.init();
    }

    @Override
    public double nextDbl() {
        return DblTruncatedSimple.valueInRange(this.baseStream.nextDbl(), this.getMinValue(), this.getMaxValue());
    }

    @Override
    public double getNumericalMean() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Pair<Double, Double> getValueRange() {
        return new Pair<Double, Double>(this.minValue, this.maxValue);
    }

    @Override
    public DblSequence clone() {
        DblTruncatedSimple c = (DblTruncatedSimple)super.clone();
        if (this.baseStream != null) {
            c.baseStream = this.baseStream.clone();
        }
        return c;
    }

    public String toString() {
        return I18n.defFormat("DblTruncatedSimple(baseStream=%s;minValue=%f;maxValue=%f)", this.getBaseStream(), this.getMinValue(), this.getMaxValue());
    }

    public DblSequence getBaseStream() {
        return this.baseStream;
    }

    public void setBaseStream(DblSequence baseStream) {
        this.baseStream = baseStream;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public static double valueInRange(double baseValue, double minValue, double maxValue) {
        if (!DblTruncatedSimple.isValidRange(minValue, maxValue)) {
            throw new IllegalArgumentException();
        }
        if (baseValue < minValue) {
            baseValue = minValue;
        }
        if (baseValue > maxValue) {
            baseValue = maxValue;
        }
        return baseValue;
    }

    private static boolean isValidRange(double min, double max) {
        return min <= max ? true : Double.isNaN(min) || Double.isNaN(max);
    }
}

