/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.random.continuous;

import jasima.core.random.continuous.DblSequence;
import jasima.core.util.Pair;
import jasima.core.util.i18n.I18n;

public class DblTriangular
extends DblSequence {
    private static final long serialVersionUID = -8098960209631757070L;
    private double min = 0.0;
    private double mode = 5.0;
    private double max = 10.0;
    private double critValue = Double.NaN;
    private double range = Double.NaN;
    private double minDist = Double.NaN;
    private double maxDist = Double.NaN;

    public DblTriangular(double min, double mode, double max) {
        if (min > mode || mode > max) {
            throw new IllegalArgumentException();
        }
        this.setMin(min);
        this.setMode(mode);
        this.setMax(max);
    }

    public static DblTriangular fromMinModeMax(double min, double mode, double max) {
        return new DblTriangular(min, mode, max);
    }

    public static DblTriangular fromMinMeanMax(double min, double mean, double max) {
        double mode = mean * 3.0 - min - max;
        return new DblTriangular(min, mode, max);
    }

    @Override
    public void init() {
        super.init();
        if (this.min > this.mode || this.mode > this.max) {
            throw new IllegalArgumentException();
        }
        this.calcInternalValues();
    }

    private void calcInternalValues() {
        this.range = this.max - this.min;
        this.minDist = this.mode - this.min;
        this.maxDist = this.max - this.mode;
        this.critValue = this.minDist / this.range;
    }

    @Override
    public double nextDbl() {
        double rnd = this.rndGen.nextDouble();
        double v = rnd <= this.critValue ? this.getMin() + Math.sqrt(this.range * this.minDist * rnd) : this.getMax() - Math.sqrt(this.range * this.maxDist * (1.0 - rnd));
        return v;
    }

    @Override
    public double getNumericalMean() {
        return (this.getMin() + this.getMode() + this.getMax()) / 3.0;
    }

    public String toString() {
        return I18n.defFormat("DblTriangular(min=%f;mode=%f;max=%f)", this.min, this.mode, this.max);
    }

    @Override
    public Pair<Double, Double> getValueRange() {
        return new Pair<Double, Double>(this.getMin(), this.getMax());
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMode() {
        return this.mode;
    }

    public void setMode(double mode) {
        this.mode = mode;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }
}

