/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.random.continuous;

import jasima.core.random.continuous.DblSequence;
import jasima.core.util.Pair;
import jasima.core.util.i18n.I18n;
import java.util.Arrays;

public class DblSumStream
extends DblSequence {
    private static final long serialVersionUID = -1978211297841470708L;
    private DblSequence[] subStreams;

    public DblSumStream() {
        this(null);
    }

    public DblSumStream(DblSequence ... subStreams) {
        this.subStreams = subStreams;
    }

    @Override
    public void init() {
        super.init();
        for (DblSequence s : this.subStreams) {
            if (s.getRndGen() == null) {
                s.setRndGen(this.getRndGen());
            }
            s.init();
        }
    }

    @Override
    public double nextDbl() {
        double sum = this.subStreams[0].nextDbl();
        int n = this.subStreams.length;
        for (int i = 1; i < n; ++i) {
            sum += this.subStreams[i].nextDbl();
        }
        return sum;
    }

    @Override
    public double getNumericalMean() {
        if (this.subStreams == null || this.subStreams.length == 0) {
            return Double.NaN;
        }
        double sum = this.subStreams[0].getNumericalMean();
        int n = this.subStreams.length;
        for (int i = 1; i < n; ++i) {
            sum += this.subStreams[i].getNumericalMean();
        }
        return sum;
    }

    @Override
    public Pair<Double, Double> getValueRange() {
        if (this.subStreams == null || this.subStreams.length == 0) {
            return new Pair<Double, Double>(Double.NaN, Double.NaN);
        }
        Pair<Double, Double> r0 = this.subStreams[0].getValueRange();
        double min = (Double)r0.a;
        double max = (Double)r0.b;
        int n = this.subStreams.length;
        for (int i = 1; i < n; ++i) {
            Pair<Double, Double> range = this.subStreams[i].getValueRange();
            min += ((Double)range.a).doubleValue();
            max += ((Double)range.b).doubleValue();
        }
        return new Pair<Double, Double>(min, max);
    }

    public String toString() {
        return I18n.defFormat("DblSumStream(subStreams=%s)", Arrays.deepToString(this.getSubStreams()));
    }

    public DblSequence[] getSubStreams() {
        return this.subStreams;
    }

    public void setSubStreams(DblSequence ... subStreams) {
        this.subStreams = subStreams;
    }
}

