/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.random.continuous;

import jasima.core.random.continuous.DblSequence;
import jasima.core.util.Pair;
import jasima.core.util.i18n.I18n;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;

public class DblNormal
extends DblSequence {
    private static final long serialVersionUID = 8266321644360710699L;
    private double mean;
    private double stdev;

    public DblNormal() {
        this(0.0, 1.0);
    }

    public DblNormal(double mean, double stdev) {
        this.setMean(mean);
        this.setStdev(stdev);
    }

    @Override
    public double nextDbl() {
        return this.getMean() + this.rndGen.nextGaussian() * this.getStdev();
    }

    @Override
    public double getNumericalMean() {
        return this.mean;
    }

    @Override
    public Pair<Double, Double> getValueRange() {
        return new Pair<Double, Double>(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public String toString() {
        return I18n.defFormat("DblNormal(mean=%f;stdev=%f)", this.getMean(), this.getStdev());
    }

    public double getMean() {
        return this.mean;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public double getStdev() {
        return this.stdev;
    }

    public void setStdev(double stdev) throws NotPositiveException {
        if (!(stdev >= 0.0)) {
            throw new NotStrictlyPositiveException((Number)stdev);
        }
        this.stdev = stdev;
    }
}

