/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.random.continuous;

import jasima.core.random.continuous.DblDistribution;
import jasima.core.util.i18n.I18n;
import org.apache.commons.math3.distribution.LogNormalDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;

public class DblLogNormal
extends DblDistribution {
    private static final long serialVersionUID = 4616829343071759004L;
    private LogNormalDistribution dist;

    public DblLogNormal() {
        this(0.0, 1.0);
    }

    public DblLogNormal(double scale, double shape) {
        this.setDistribution((RealDistribution)new LogNormalDistribution(scale, shape));
    }

    @Override
    protected void setDistribution(RealDistribution distribution) {
        this.dist = (LogNormalDistribution)distribution;
        super.setDistribution(distribution);
    }

    @Override
    public String toString() {
        return I18n.defFormat("DblLogNormal(shape=%f;scale=%f)", this.getShape(), this.getScale());
    }

    public double getScale() {
        return this.dist.getScale();
    }

    public void setScale(double scale) {
        this.setDistribution((RealDistribution)new LogNormalDistribution(scale, this.getShape()));
    }

    public double getShape() {
        return this.dist.getShape();
    }

    public void setShape(double shape) throws NotStrictlyPositiveException {
        this.setDistribution((RealDistribution)new LogNormalDistribution(this.getScale(), shape));
    }
}

