/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.random.continuous;

import jasima.core.random.continuous.DblDistribution;
import jasima.core.util.i18n.I18n;
import org.apache.commons.math3.distribution.GammaDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;

public class DblGamma
extends DblDistribution {
    private static final long serialVersionUID = 8196438918640991723L;
    private GammaDistribution dist;

    public DblGamma() {
        this(2.0, 2.0);
    }

    public DblGamma(double shape, double scale) {
        this.setDistribution((RealDistribution)new GammaDistribution(shape, scale));
    }

    @Override
    protected void setDistribution(RealDistribution distribution) {
        this.dist = (GammaDistribution)distribution;
        super.setDistribution(distribution);
    }

    @Override
    public String toString() {
        return I18n.defFormat("DblGamma(shape=%f;scale=%f)", this.getShape(), this.getScale());
    }

    public double getShape() {
        return this.dist.getShape();
    }

    public void setShape(double shape) throws NotStrictlyPositiveException {
        this.setDistribution((RealDistribution)new GammaDistribution(shape, this.dist.getScale()));
    }

    public double getScale() {
        return this.dist.getScale();
    }

    public void setScale(double scale) throws NotStrictlyPositiveException {
        this.setDistribution((RealDistribution)new GammaDistribution(this.dist.getShape(), scale));
    }
}

