/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.random.continuous;

import jasima.core.random.continuous.DblDistribution;
import jasima.core.random.continuous.DblSequence;
import jasima.core.util.i18n.I18n;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;

public final class DblExp
extends DblDistribution {
    private static final long serialVersionUID = 7949202789555424738L;
    public static final double DEFAULT_MEAN = 1.0;
    private ExponentialDistribution dist;

    public DblExp() {
        this(1.0);
    }

    public DblExp(double mean) {
        this.setMean(mean);
    }

    public double getMean() {
        return this.dist.getMean();
    }

    public void setMean(double mean) throws NotStrictlyPositiveException {
        this.dist = new ExponentialDistribution(mean);
        this.setDistribution((RealDistribution)this.dist);
    }

    @Override
    public String toString() {
        return I18n.defFormat("DblExp(mean=%f)", this.getMean());
    }

    @Override
    public DblSequence clone() {
        return super.clone();
    }
}

