/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.random.continuous;

import jasima.core.random.continuous.DblSequence;
import jasima.core.util.Pair;
import jasima.core.util.i18n.I18n;
import java.util.Random;

public class DblErlang
extends DblSequence {
    private static final long serialVersionUID = -1862722756069025018L;
    private int shape;
    private double scale;

    public DblErlang() {
        this(1, 1.0);
    }

    public DblErlang(int shape, double scale) {
        this.shape = shape;
        this.scale = scale;
    }

    @Override
    public double nextDbl() {
        Random rnd = this.getRndGen();
        double unifProduct = 1.0;
        for (int i = 0; i < this.shape; ++i) {
            unifProduct *= rnd.nextDouble();
        }
        return -this.scale * Math.log(unifProduct);
    }

    @Override
    public double getNumericalMean() {
        return (double)this.shape * this.scale;
    }

    @Override
    public Pair<Double, Double> getValueRange() {
        return new Pair<Double, Double>(0.0, Double.POSITIVE_INFINITY);
    }

    public int getShape() {
        return this.shape;
    }

    public void setShape(int shape) {
        if (shape < 1) {
            throw new IllegalArgumentException();
        }
        this.shape = shape;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        if (!(scale > 0.0)) {
            throw new IllegalArgumentException();
        }
        this.scale = scale;
    }

    public String toString() {
        return I18n.defFormat("DblErlang(sape=%d;scale=%f)", this.getShape(), this.getScale());
    }
}

