/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.random.continuous;

import jasima.core.random.continuous.DblSequence;
import jasima.core.util.Pair;
import java.util.Random;
import org.apache.commons.math3.distribution.RealDistribution;

public class DblDistribution
extends DblSequence {
    private static final long serialVersionUID = -157283852135250753L;
    private RealDistribution distribution;

    public DblDistribution() {
        this(null, null, null);
    }

    public DblDistribution(RealDistribution distribution) {
        this(null, null, distribution);
    }

    public DblDistribution(Random random, RealDistribution distribution) {
        this(random, null, distribution);
    }

    public DblDistribution(String name, RealDistribution distribution) {
        this(null, name, distribution);
    }

    public DblDistribution(Random random, String name, RealDistribution distribution) {
        this.setRndGen(random);
        this.setDistribution(distribution);
        this.setName(name);
    }

    public RealDistribution getDistribution() {
        return this.distribution;
    }

    protected void setDistribution(RealDistribution distribution) {
        this.distribution = distribution;
    }

    @Override
    public double nextDbl() {
        return this.distribution.inverseCumulativeProbability(this.rndGen.nextDouble());
    }

    @Override
    public double getNumericalMean() {
        if (this.distribution == null) {
            return Double.NaN;
        }
        return this.distribution.getNumericalMean();
    }

    @Override
    public Pair<Double, Double> getValueRange() {
        if (this.distribution == null) {
            return null;
        }
        return new Pair<Double, Double>(this.distribution.getSupportLowerBound(), this.distribution.getSupportUpperBound());
    }

    public String toString() {
        return "DblDistribution(" + String.valueOf(this.distribution) + ')';
    }
}

