/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.random.continuous;

import jasima.core.random.continuous.DblSequence;
import jasima.core.util.Pair;
import jasima.core.util.Util;
import java.util.Arrays;

public class DblConst
extends DblSequence {
    private static final long serialVersionUID = -2122011743105354569L;
    private double[] values;
    private boolean randomizeOrder;
    private Double mean;
    private int next = Integer.MAX_VALUE;
    private double[] valuesRnd;

    public DblConst() {
        this(null);
    }

    public DblConst(double ... vs) {
        this.setValues(vs);
    }

    private void nextIteration() {
        this.next = 0;
        if (this.isRandomizeOrder()) {
            Util.shuffle(this.valuesRnd, this.rndGen);
        }
    }

    @Override
    public double nextDbl() {
        if (this.next >= this.valuesRnd.length) {
            this.nextIteration();
        }
        double v = this.valuesRnd[this.next];
        ++this.next;
        return v;
    }

    public String toString() {
        return "DblConst" + Arrays.toString(this.values);
    }

    @Override
    public DblConst clone() {
        DblConst c = (DblConst)super.clone();
        if (this.values != null) {
            c.values = (double[])this.values.clone();
        }
        if (this.valuesRnd != null) {
            c.valuesRnd = (double[])this.valuesRnd.clone();
        }
        return c;
    }

    @Override
    public double getNumericalMean() {
        if (this.mean == null) {
            this.mean = this.values == null || this.values.length == 0 ? Double.valueOf(Double.NaN) : Double.valueOf(Util.sum(this.values) / (double)this.values.length);
        }
        return this.mean;
    }

    @Override
    public Pair<Double, Double> getValueRange() {
        if (this.values == null || this.values.length == 0) {
            return new Pair<Double, Double>(Double.NaN, Double.NaN);
        }
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (double d : this.values) {
            if (!(min <= d)) {
                min = d;
            }
            if (max >= d) continue;
            max = d;
        }
        return new Pair<Double, Double>(min, max);
    }

    public double[] getValues() {
        return this.values == null ? null : (double[])this.values.clone();
    }

    public void setValues(double ... vs) {
        this.mean = null;
        if (vs == null) {
            this.values = null;
            this.valuesRnd = null;
        } else {
            this.values = (double[])vs.clone();
            this.valuesRnd = (double[])vs.clone();
        }
    }

    public boolean isRandomizeOrder() {
        return this.randomizeOrder;
    }

    public void setRandomizeOrder(boolean randomizeOrder) {
        this.randomizeOrder = randomizeOrder;
    }
}

