/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.random.continuous;

import jasima.core.random.continuous.DblDistribution;
import jasima.core.util.i18n.I18n;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;

public class DblChiSquared
extends DblDistribution {
    private static final long serialVersionUID = -5702591884949743185L;
    private ChiSquaredDistribution dist;

    public DblChiSquared() {
        this(2);
    }

    public DblChiSquared(int degreesOfFreedom) {
        this.setDistribution((RealDistribution)new ChiSquaredDistribution((double)degreesOfFreedom));
    }

    @Override
    public String toString() {
        return I18n.defFormat("DblChiSquared(degreesOfFreedom=%d)", this.getDegreesOfFreedom());
    }

    @Override
    protected void setDistribution(RealDistribution distribution) {
        this.dist = (ChiSquaredDistribution)distribution;
        super.setDistribution(distribution);
    }

    public int getDegreesOfFreedom() {
        return (int)this.dist.getDegreesOfFreedom();
    }

    public void setDegreesOfFreedom(int degreesOfFreedom) throws NotStrictlyPositiveException {
        this.setDistribution((RealDistribution)new ChiSquaredDistribution((double)degreesOfFreedom));
    }
}

