/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.random.continuous;

import jasima.core.random.continuous.DblDistribution;
import jasima.core.util.i18n.I18n;
import org.apache.commons.math3.distribution.BetaDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;

public class DblBeta
extends DblDistribution {
    private static final long serialVersionUID = -5717640931580338541L;
    private BetaDistribution dist;

    public DblBeta() {
        this(2.0, 5.0);
    }

    public DblBeta(double alpha, double beta) {
        this.setDistribution((RealDistribution)new BetaDistribution(alpha, beta));
    }

    @Override
    protected void setDistribution(RealDistribution distribution) {
        this.dist = (BetaDistribution)distribution;
        super.setDistribution(distribution);
    }

    @Override
    public String toString() {
        return I18n.defFormat("DblBeta(alpha=%f;beta=%f)", this.getAlpha(), this.getBeta());
    }

    public double getAlpha() {
        return this.dist.getAlpha();
    }

    public void setAlpha(double alpha) throws NotStrictlyPositiveException {
        this.setDistribution((RealDistribution)new BetaDistribution(alpha, this.getBeta()));
    }

    public double getBeta() {
        return this.dist.getBeta();
    }

    public void setBeta(double beta) throws NotStrictlyPositiveException {
        this.setDistribution((RealDistribution)new BetaDistribution(this.getAlpha(), beta));
    }
}

