/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.random;

import jasima.core.random.continuous.DblSequence;
import jasima.core.simulation.Simulation;
import jasima.core.util.MersenneTwister;
import jasima.core.util.MsgCategory;
import jasima.core.util.TypeUtil;
import jasima.core.util.i18n.I18n;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class RandomFactory
implements Serializable {
    private static final long serialVersionUID = 4828925858942593527L;
    public static final String RANDOM_FACTORY_PROP_KEY = RandomFactory.class.getName();
    public static Class<? extends RandomFactory> randomFactoryClass = TypeUtil.getClassFromSystemProperty(RANDOM_FACTORY_PROP_KEY, RandomFactory.class, RandomFactory.class);
    public static final String RANDOM_CLASS_PROP_KEY = RandomFactory.class.getName() + ".randomClass";
    public static Class<? extends Random> randomClass = TypeUtil.getClassFromSystemProperty(RANDOM_CLASS_PROP_KEY, Random.class, MersenneTwister.class);
    private HashMap<Long, String> seeds = new HashMap();
    private Random seedStream = new Random();
    private long hashMask = 5787905968364136369L;
    private Simulation sim;

    public static RandomFactory newInstance() {
        RandomFactory f = TypeUtil.createInstance(randomFactoryClass);
        f.setSeed(902790708899L);
        return f;
    }

    public RandomFactory() {
    }

    public RandomFactory(Simulation sim, long initialSeed) {
        this();
        this.setSim(sim);
        this.setSeed(initialSeed);
    }

    public Random createInstance(String name) {
        Consumer<String> warningReceiver = this.getSim() == null ? null : msg -> this.getSim().print(MsgCategory.WARN, (String)msg);
        return this.createInstance(name, warningReceiver);
    }

    public Random createInstance(String name, @Nullable Consumer<String> warningReceiver) {
        long seed = this.getSeed(name, warningReceiver);
        if (this.getSim() != null) {
            this.getSim().print(MsgCategory.DEBUG, I18n.defFormat("created random stream '%s' with initial seed %d.", name, seed));
            if (this.getSim().isTraceEnabled()) {
                this.getSim().trace("create_random_stream", name, seed);
            }
        }
        return this.createRandom(seed);
    }

    protected Random createRandom(long seed) {
        Random o = TypeUtil.createInstance(randomClass);
        o.setSeed(seed);
        return o;
    }

    protected long getSeed(String name, @Nullable Consumer<String> warningReceiver) {
        String s;
        int hashCode = name.hashCode();
        long nameHash = (long)hashCode << 32 | (long)(~hashCode);
        this.seedStream.setSeed(nameHash ^ this.hashMask);
        long seed = this.seedStream.nextLong();
        while ((s = this.seeds.get(seed)) != null) {
            if (s.equals(name)) {
                throw new IllegalArgumentException("Already created stream '" + name + "', please use unique names.");
            }
            if (warningReceiver != null) {
                String warningMsg = I18n.defFormat("Collision for random streams named '%s' and '%s'. If possible use different stream names to avoid problems with comparability/reproducability of results.", name, s);
                warningReceiver.accept(warningMsg);
            }
            seed = this.seedStream.nextLong();
        }
        this.seeds.put(seed, name);
        return seed;
    }

    public void setSeed(long seed) {
        this.hashMask = new Random(seed).nextLong();
        this.seeds.clear();
    }

    public <T extends DblSequence> T initRndGen(T stream, String defaultName) {
        if (stream == null || stream.getRndGen() != null) {
            return stream;
        }
        String name = stream.getName();
        if (name == null) {
            name = defaultName;
        }
        if (name == null) {
            throw new IllegalArgumentException("No stream name provided.");
        }
        stream.setRndGen(this.createInstance(name));
        stream.init();
        return stream;
    }

    public DblSequence initRndGen(DblSequence stream) {
        return this.initRndGen(stream, null);
    }

    public Simulation getSim() {
        return this.sim;
    }

    public void setSim(Simulation sim) {
        this.sim = sim;
    }

    public static void reloadSysProps() {
        randomFactoryClass = TypeUtil.getClassFromSystemProperty(RANDOM_FACTORY_PROP_KEY, RandomFactory.class, RandomFactory.class);
        randomClass = TypeUtil.getClassFromSystemProperty(RANDOM_CLASS_PROP_KEY, Random.class, MersenneTwister.class);
    }
}

