/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.experiment;

import jasima.core.experiment.FullFactorialExperiment;
import jasima.core.util.MersenneTwister;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;

public class RandomFractionalExperiment
extends FullFactorialExperiment {
    private static final int DEF_MAX_CONFS = 100;
    private static final long serialVersionUID = 6227676813209467282L;
    private Random rnd;

    public RandomFractionalExperiment() {
        this(100);
    }

    public RandomFractionalExperiment(int numDesigns) {
        this.setMaxConfigurations(numDesigns);
    }

    @Override
    public void init() {
        super.init();
        this.rnd = new MersenneTwister(this.getInitialSeed());
    }

    @Override
    protected void createExperiments() {
        int numFactors = this.getFactorNames().size();
        int[] numValuesPerFactor = new int[numFactors];
        long total = 1L;
        int i = 0;
        for (String name : this.getFactorNames()) {
            int n = this.getFactorValues(name).size();
            numValuesPerFactor[i++] = n;
            total *= (long)n;
        }
        int max = this.getMaxConfigurations() > 0 ? this.getMaxConfigurations() : Integer.MAX_VALUE;
        long numCfgsToCreate = Math.min((long)max, total);
        this.print("creating %d configurations out of %d possible...", numCfgsToCreate, total);
        this.numConfs = 0;
        this.sampleConfs((int)numCfgsToCreate, numValuesPerFactor);
        this.print("%d valid configurations found.", this.experiments.size());
    }

    private void sampleConfs(int numCfgsToCreate, int[] numValuesPerFactor) {
        int numFactors = this.getFactorNames().size();
        int[][] confs = new int[numFactors][numCfgsToCreate];
        for (int n = 0; n < numFactors; ++n) {
            this.initConfDim(confs[n], numValuesPerFactor[n]);
        }
        HashSet<IntArrayWrapper> cfgs = new HashSet<IntArrayWrapper>();
        boolean cont = true;
        block1: while (cont) {
            int n;
            for (n = 0; n < confs.length; ++n) {
                this.shuffle(confs[n]);
            }
            for (n = confs[0].length - 1; n >= 0; --n) {
                int[] conf = new int[numFactors];
                for (int j = 0; j < conf.length; ++j) {
                    conf[j] = confs[j][n];
                }
                IntArrayWrapper w = new IntArrayWrapper(conf);
                if (cfgs.contains(w)) continue;
                cfgs.add(w);
                if (cfgs.size() != numCfgsToCreate) continue;
                cont = false;
                continue block1;
            }
        }
        ArrayList l = new ArrayList(cfgs);
        Collections.sort(l);
        for (IntArrayWrapper iaw : l) {
            this.addExperimentForConf(iaw.is);
        }
    }

    private void shuffle(int[] is) {
        int n = is.length;
        for (int i = 0; i < n; ++i) {
            int b = i + this.rnd.nextInt(n - i);
            int x = is[i];
            is[i] = is[b];
            is[b] = x;
        }
    }

    private void initConfDim(int[] is, int numValues) {
        double n = (double)is.length * 1.0 / (double)numValues;
        int m = (int)Math.floor(n);
        int p = 0;
        for (int i = 0; i < numValues; ++i) {
            for (int j = 0; j < m; ++j) {
                is[p++] = i;
            }
        }
        assert (is.length - p < numValues);
        int[] v = new int[numValues];
        for (int i = 0; i < v.length; ++i) {
            v[i] = i;
        }
        this.shuffle(v);
        int q = 0;
        while (p < is.length) {
            is[p++] = v[q++];
        }
    }

    private static class IntArrayWrapper
    implements Comparable<IntArrayWrapper> {
        public final int[] is;

        public IntArrayWrapper(int[] is) {
            this.is = is;
        }

        public int hashCode() {
            return Arrays.hashCode(this.is);
        }

        public boolean equals(Object o) {
            return Arrays.equals(this.is, ((IntArrayWrapper)o).is);
        }

        @Override
        public int compareTo(IntArrayWrapper o) {
            assert (this.is.length == o.is.length);
            for (int i = 0; i < this.is.length; ++i) {
                int diff = this.is[i] - o.is[i];
                if (diff == 0) continue;
                return diff;
            }
            return 0;
        }
    }
}

