/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.experiment;

import jasima.core.experiment.AbstractMultiExperiment;
import jasima.core.experiment.Experiment;
import jasima.core.statistics.SummaryStat;
import jasima.core.util.MsgCategory;
import jasima.core.util.Pair;
import jasima.core.util.i18n.I18n;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.math3.analysis.solvers.RiddersSolver;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;

public class MultipleReplicationExperiment
extends AbstractMultiExperiment {
    private static final long serialVersionUID = -5122164015247766742L;
    private Experiment baseExperiment;
    private int minReplications = 0;
    private int maxReplications = 10;
    private String[] confIntervalMeasures = new String[0];
    private double errorProb = 0.05;
    private double allowancePercentage = 0.01;

    public MultipleReplicationExperiment() {
        this.setAbortUponBaseExperimentAbort(true);
        this.setCommonRandomNumbers(false);
    }

    public MultipleReplicationExperiment(Experiment e, int numReps) {
        this();
        this.setBaseExperiment(e);
        this.setMaxReplications(numReps);
    }

    @Override
    protected void createExperiments() {
        this.experiments.clear();
        int batchSize = this.getNumExperiments();
        for (int i = 0; i < batchSize; ++i) {
            Experiment e = this.getBaseExperiment().clone();
            this.configureRunExperiment(e);
            this.experiments.add(e);
        }
    }

    @Override
    protected boolean hasMoreTasks() {
        if (!this.isNumRunsDynamic()) {
            return false;
        }
        if (this.numTasksExecuted >= this.getMaxReplications()) {
            return false;
        }
        for (String name : this.confIntervalMeasures) {
            SummaryStat vs;
            Pair data = (Pair)this.detailedResultsNumeric.get(name);
            SummaryStat summaryStat = vs = data == null ? null : (SummaryStat)data.b;
            if (vs == null) {
                throw new RuntimeException(I18n.defFormat("No results for name '%s'.", name));
            }
            double allowance = Math.abs(vs.mean() * this.allowancePercentage);
            double interv = vs.confIntRangeSingle(this.getErrorProb());
            this.print(MsgCategory.INFO, "dynamic number of replications\tobjective: '%s'\tcurrent mean: %f\tconfInt: \u00b1%f\ttarget: \u00b1%f\testimated total replications: %d", name, vs.mean(), interv, allowance, this.estimateNumReps(vs, allowance));
            if (interv <= allowance) continue;
            return true;
        }
        return false;
    }

    private int estimateNumReps(SummaryStat vs, double allowance) {
        if (vs.weightSum() < 2.0) {
            return -1;
        }
        try {
            double c1 = this.errorProb * 0.5;
            double numReps = new RiddersSolver(0.5).solve(100, v -> {
                TDistribution dist = new TDistribution(v - 1.0);
                return Math.abs(dist.inverseCumulativeProbability(c1)) * Math.sqrt(vs.variance() / v) - allowance;
            }, 2.0, 1000000.0, vs.weightSum());
            return (int)Math.round(numReps);
        }
        catch (NoBracketingException | TooManyEvaluationsException ignore) {
            return -1;
        }
    }

    @Override
    protected final String prefix() {
        return "rep";
    }

    @Override
    public int getNumExperiments() {
        if (this.isNumRunsDynamic()) {
            int reps = this.getMinReplications();
            if (reps <= 0) {
                reps = Runtime.getRuntime().availableProcessors();
            }
            if (reps > this.getMaxReplications()) {
                reps = this.getMaxReplications();
            }
            return reps;
        }
        return this.getMaxReplications();
    }

    private boolean isNumRunsDynamic() {
        return this.confIntervalMeasures.length > 0;
    }

    public int getMinReplications() {
        return this.minReplications;
    }

    public void setMinReplications(int minReplications) {
        if (minReplications < 0) {
            throw new IllegalArgumentException("" + minReplications);
        }
        this.minReplications = minReplications;
    }

    public int getMaxReplications() {
        return this.maxReplications;
    }

    public void setMaxReplications(int maxReplications) {
        if (maxReplications <= 0 || maxReplications < this.getMinReplications()) {
            throw new IllegalArgumentException("" + maxReplications);
        }
        this.maxReplications = maxReplications;
    }

    public double getErrorProb() {
        return this.errorProb;
    }

    public void setErrorProb(double errorProb) {
        if (errorProb <= 0.0 || errorProb >= 1.0) {
            throw new IllegalArgumentException(I18n.defFormat("errorProb should be in the interval (0,1). invalid: %f", errorProb));
        }
        this.errorProb = errorProb;
    }

    public double getAllowancePercentage() {
        return this.allowancePercentage;
    }

    public void setAllowancePercentage(double allowancePercentage) {
        if (allowancePercentage <= 0.0 || allowancePercentage >= 1.0) {
            throw new IllegalArgumentException(I18n.defFormat("allowancePercentage should be in the interval (0,1). invalid: %f", allowancePercentage));
        }
        this.allowancePercentage = allowancePercentage;
    }

    public void addConfIntervalMeasure(String name) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(this.confIntervalMeasures));
        list.add(name);
        this.confIntervalMeasures = list.toArray(new String[list.size()]);
    }

    public boolean removeConfIntervalMeasure(String name) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(this.confIntervalMeasures));
        boolean res = list.remove(name);
        this.confIntervalMeasures = list.toArray(new String[list.size()]);
        return res;
    }

    public String[] getConfIntervalMeasures() {
        return this.confIntervalMeasures;
    }

    public void setConfIntervalMeasures(String ... confIntervalMeasures) {
        this.confIntervalMeasures = confIntervalMeasures;
    }

    public Experiment getBaseExperiment() {
        return this.baseExperiment;
    }

    public void setBaseExperiment(Experiment baseExperiment) {
        this.baseExperiment = baseExperiment;
    }

    @Override
    public MultipleReplicationExperiment clone() {
        MultipleReplicationExperiment mre = (MultipleReplicationExperiment)super.clone();
        if (this.confIntervalMeasures != null) {
            mre.confIntervalMeasures = (String[])this.confIntervalMeasures.clone();
        }
        if (this.baseExperiment != null) {
            mre.baseExperiment = this.baseExperiment.clone();
        }
        return mre;
    }
}

