/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.experiment;

import jasima.core.experiment.AbstractMultiConfExperiment;
import jasima.core.experiment.Experiment;
import jasima.core.util.MsgCategory;
import jasima.core.util.i18n.I18n;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class FullFactorialExperiment
extends AbstractMultiConfExperiment {
    private static final long serialVersionUID = 1612150171949724274L;
    private int maxConfigurations = 1000000;
    private Map<String, List<Object>> factors;
    private ArrayList<String> factorNames;

    public FullFactorialExperiment() {
        this(null);
    }

    public FullFactorialExperiment(@Nullable Experiment baseExperiment) {
        this.setAbortUponBaseExperimentAbort(false);
        this.factors = new LinkedHashMap<String, List<Object>>();
        this.setBaseExperiment(baseExperiment);
    }

    public void clearFactors() {
        this.factors.clear();
    }

    public void addFactorValue(String name, Object value) {
        List<Object> values = this.factors.get(name);
        if (values == null) {
            values = new ArrayList<Object>();
            this.factors.put(name, values);
        }
        if (values.contains(value)) {
            throw new IllegalArgumentException("No duplicate values allowed: '" + value + "' (factor '" + name + "')");
        }
        values.add(value);
    }

    public void addFactorValue(String name, AbstractMultiConfExperiment.ComplexFactorSetter value) {
        this.addFactorValue(name, (Object)value);
    }

    public <E extends Enum<?>> void addFactor(String factorName, Class<E> enumClass) {
        for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
            this.addFactorValue(factorName, enumValue);
        }
    }

    public void addFactor(String factorName, Object ... values) {
        for (Object o : values) {
            this.addFactorValue(factorName, o);
        }
    }

    public void addFactor(String factorName, Collection<?> values) {
        for (Object o : values) {
            this.addFactorValue(factorName, o);
        }
    }

    public Collection<String> getFactorNames() {
        return Collections.unmodifiableSet(this.factors.keySet());
    }

    public List<?> getFactorValues(String name) {
        List<Object> res = this.factors.get(name);
        return res == null ? null : Collections.unmodifiableList(res);
    }

    @Override
    public FullFactorialExperiment clone() {
        FullFactorialExperiment e = (FullFactorialExperiment)super.clone();
        e.factors = new LinkedHashMap<String, List<Object>>(this.factors);
        return e;
    }

    @Override
    protected void createExperiments() {
        this.factorNames = new ArrayList<String>(this.getFactorNames());
        int numFactors = this.factorNames.size();
        int[] numValuesPerFactor = new int[numFactors];
        long total = 1L;
        int i = 0;
        for (String name : this.factorNames) {
            long last;
            int n = this.getFactorValues(name).size();
            numValuesPerFactor[i++] = n;
            if ((total *= (long)n) >= (last = total)) continue;
            throw new RuntimeException("Too many combinations.");
        }
        this.print(MsgCategory.INFO, "building and validating configurations, %d theoretical combinations ...", total);
        int[] is = new int[numFactors];
        do {
            this.addExperimentForConf(is);
            if (this.getMaxConfigurations() <= 0 || this.experiments.size() <= this.getMaxConfigurations()) continue;
            throw new RuntimeException(String.format(I18n.DEF_LOCALE, "More than %d configurations. Consider reducing the number of factors and/or factor values or using an optimization algorithm instead.", this.getMaxConfigurations()));
        } while (FullFactorialExperiment.createNextCombination(is, numValuesPerFactor));
        this.print(MsgCategory.INFO, "executing %d experiments ...", this.experiments.size());
        this.factorNames = null;
    }

    private static boolean createNextCombination(int[] is, int[] numValuesPerFactor) {
        assert (is.length == numValuesPerFactor.length);
        for (int i = is.length - 1; i >= 0; --i) {
            int n = i;
            is[n] = is[n] + 1;
            if (is[n] < numValuesPerFactor[i]) {
                return true;
            }
            is[i] = 0;
        }
        return false;
    }

    protected void addExperimentForConf(int[] conf) {
        assert (conf.length == this.factorNames.size());
        HashMap<String, Object> c = new HashMap<String, Object>();
        for (int f = 0; f < conf.length; ++f) {
            String name = this.factorNames.get(f);
            Object value = this.factors.get(name).get(conf[f]);
            c.put(name, value);
        }
        Experiment e = this.createExperimentForConf(c);
        if (e != null) {
            this.experiments.add(e);
        }
    }

    @Override
    public void setCommonRandomNumbers(boolean commonRandomNumbers) {
        super.setCommonRandomNumbers(commonRandomNumbers);
    }

    public int getMaxConfigurations() {
        return this.maxConfigurations;
    }

    public void setMaxConfigurations(int maxConfigurations) {
        this.maxConfigurations = maxConfigurations;
    }
}

