/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.experiment;

import jasima.core.experiment.Experiment;
import jasima.core.util.MsgCategory;
import jasima.core.util.i18n.I18n;
import java.util.Locale;

public enum ExperimentMessage implements Experiment.ExperimentEvent
{
    EXPERIMENT_STARTING,
    EXPERIMENT_INITIALIZED,
    EXPERIMENT_BEFORE_RUN,
    EXPERIMENT_RUN_PERFORMED,
    EXPERIMENT_AFTER_RUN,
    EXPERIMENT_DONE,
    EXPERIMENT_COLLECTING_RESULTS,
    EXPERIMENT_FINISHING,
    EXPERIMENT_FINISHED,
    EXPERIMENT_ERROR,
    EXPERIMENT_FINALLY;


    public static class ExpPrintMessage
    implements Experiment.ExperimentEvent {
        public final Experiment exp;
        public final MsgCategory category;
        private String message;
        private String messageFormatString;
        private Object[] params;

        public ExpPrintMessage(Experiment exp, MsgCategory category, String message) {
            if (message == null) {
                throw new NullPointerException();
            }
            this.exp = exp;
            this.category = category;
            this.message = message;
        }

        public ExpPrintMessage(Experiment exp, MsgCategory category, String messageFormatString, Object ... params) {
            this.exp = exp;
            this.category = category;
            this.messageFormatString = messageFormatString;
            this.params = params;
            this.message = null;
        }

        public String getMessage() {
            return this.getMessage(I18n.DEF_LOCALE);
        }

        public String getMessage(Locale locale) {
            if (this.message == null) {
                this.message = String.format(locale, this.messageFormatString, this.params);
                this.messageFormatString = null;
                this.params = null;
            }
            return this.message;
        }

        public String toString() {
            return this.getMessage();
        }
    }
}

