/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.experiment;

import jasima.core.experiment.AbstractMultiExperiment;
import jasima.core.experiment.Experiment;
import jasima.core.experiment.ExperimentMessage;
import jasima.core.util.observer.NotifierListener;
import java.util.Map;

public interface ExperimentListener
extends NotifierListener<Experiment, Experiment.ExperimentEvent> {
    @Override
    default public void inform(Experiment e, Experiment.ExperimentEvent event) {
        if (event == ExperimentMessage.EXPERIMENT_STARTING) {
            this.starting(e);
        } else if (event == ExperimentMessage.EXPERIMENT_INITIALIZED) {
            this.initialized(e);
        } else if (event == ExperimentMessage.EXPERIMENT_BEFORE_RUN) {
            this.beforeRun(e);
        } else if (event == ExperimentMessage.EXPERIMENT_RUN_PERFORMED) {
            this.runPerformed(e);
        } else if (event == ExperimentMessage.EXPERIMENT_AFTER_RUN) {
            this.afterRun(e);
        } else if (event == ExperimentMessage.EXPERIMENT_DONE) {
            this.done(e);
        } else if (event == ExperimentMessage.EXPERIMENT_COLLECTING_RESULTS) {
            this.produceResults(e, e.resultMap);
        } else if (event == ExperimentMessage.EXPERIMENT_FINISHING) {
            this.finishing(e, e.resultMap);
        } else if (event == ExperimentMessage.EXPERIMENT_FINISHED) {
            this.finished(e, e.resultMap);
        } else if (event == ExperimentMessage.EXPERIMENT_ERROR) {
            this.error(e, e.error);
        } else if (event == ExperimentMessage.EXPERIMENT_FINALLY) {
            this.finalAction(e);
        } else if (event instanceof ExperimentMessage.ExpPrintMessage) {
            this.print(e, (ExperimentMessage.ExpPrintMessage)event);
        } else if (event instanceof AbstractMultiExperiment.BaseExperimentCompleted) {
            AbstractMultiExperiment.BaseExperimentCompleted evt = (AbstractMultiExperiment.BaseExperimentCompleted)event;
            this.multiExperimentCompletedTask(e, evt.experimentRun, evt.results);
        } else {
            this.handleOther(e, event);
        }
    }

    default public void handleOther(Experiment e, Experiment.ExperimentEvent event) {
    }

    default public void print(Experiment e, ExperimentMessage.ExpPrintMessage event) {
    }

    default public void starting(Experiment e) {
    }

    default public void initialized(Experiment e) {
    }

    default public void beforeRun(Experiment e) {
    }

    default public void runPerformed(Experiment e) {
    }

    default public void afterRun(Experiment e) {
    }

    default public void done(Experiment e) {
    }

    default public void produceResults(Experiment e, Map<String, Object> res) {
    }

    default public void finishing(Experiment e, Map<String, Object> results) {
    }

    default public void finished(Experiment e, Map<String, Object> results) {
    }

    default public void multiExperimentCompletedTask(Experiment baseExp, Experiment runExperiment, Map<String, Object> runResults) {
    }

    default public void error(Experiment e, Throwable t) {
    }

    default public void finalAction(Experiment e) {
    }

    @FunctionalInterface
    public static interface FinallyListener
    extends ExperimentListener {
        @Override
        public void finalAction(Experiment var1);
    }

    @FunctionalInterface
    public static interface ErrorListener
    extends ExperimentListener {
        @Override
        public void error(Experiment var1, Throwable var2);
    }

    @FunctionalInterface
    public static interface MultiExperimentCompletedTaskListener
    extends ExperimentListener {
        @Override
        public void multiExperimentCompletedTask(Experiment var1, Experiment var2, Map<String, Object> var3);
    }

    @FunctionalInterface
    public static interface FinishedListener
    extends ExperimentListener {
        @Override
        public void finished(Experiment var1, Map<String, Object> var2);
    }

    @FunctionalInterface
    public static interface FinishingListener
    extends ExperimentListener {
        @Override
        public void finishing(Experiment var1, Map<String, Object> var2);
    }

    @FunctionalInterface
    public static interface ProduceResultsListener
    extends ExperimentListener {
        @Override
        public void produceResults(Experiment var1, Map<String, Object> var2);
    }

    @FunctionalInterface
    public static interface DoneListener
    extends ExperimentListener {
        @Override
        public void done(Experiment var1);
    }

    @FunctionalInterface
    public static interface AfterRunListener
    extends ExperimentListener {
        @Override
        public void afterRun(Experiment var1);
    }

    @FunctionalInterface
    public static interface RunPerformedListener
    extends ExperimentListener {
        @Override
        public void runPerformed(Experiment var1);
    }

    @FunctionalInterface
    public static interface BeforeRunListener
    extends ExperimentListener {
        @Override
        public void beforeRun(Experiment var1);
    }

    @FunctionalInterface
    public static interface InitializedListener
    extends ExperimentListener {
        @Override
        public void initialized(Experiment var1);
    }

    @FunctionalInterface
    public static interface StartingListener
    extends ExperimentListener {
        @Override
        public void starting(Experiment var1);
    }

    @FunctionalInterface
    public static interface PrintListener
    extends ExperimentListener {
        @Override
        public void print(Experiment var1, ExperimentMessage.ExpPrintMessage var2);
    }

    @FunctionalInterface
    public static interface HandleOtherListener
    extends ExperimentListener {
        @Override
        public void handleOther(Experiment var1, Experiment.ExperimentEvent var2);
    }
}

