/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.experiment;

import jasima.core.experiment.Experiment;
import jasima.core.experiment.ExperimentListener;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ExperimentCompletableFuture
extends CompletableFuture<Map<String, Object>> {
    private final Experiment experiment;
    private final Future<Map<String, Object>> future;

    public ExperimentCompletableFuture(Experiment e, ExecutorService es) {
        this.experiment = Objects.requireNonNull(e);
        e.aboutToStart();
        this.addFinishedListener();
        this.future = es.submit(e::runExperimentInternal);
    }

    private void addFinishedListener() {
        ExperimentListener finallyListener = new ExperimentListener(){

            @Override
            public void finalAction(Experiment e) {
                if (e.getError() != null) {
                    ExperimentCompletableFuture.this.completeExceptionally(e.getError());
                } else {
                    ExperimentCompletableFuture.this.complete(e.getResults());
                }
                e.removeCurrentListener();
            }
        };
        this.experiment.addListener(finallyListener);
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public Map<String, Object> joinIgnoreExceptions() {
        CompletionStage whenFinished = this.handle((T r, U ex) -> this.experiment.getResults());
        return (Map)((CompletableFuture)whenFinished).join();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.experiment.cancel();
        boolean res = this.future.cancel(mayInterruptIfRunning);
        super.cancel(mayInterruptIfRunning);
        return res;
    }

    public boolean cancel() {
        return this.cancel(true);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public Map<String, Object> get() throws ExecutionException, InterruptedException {
        return this.future.get();
    }

    @Override
    public Map<String, Object> get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        return this.future.get(timeout, unit);
    }
}

