/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.experiment;

import jasima.core.expExecution.ExperimentExecutor;
import jasima.core.experiment.ExperimentCompletableFuture;
import jasima.core.experiment.ExperimentMessage;
import jasima.core.run.ConsoleRunner;
import jasima.core.util.ConsolePrinter;
import jasima.core.util.MsgCategory;
import jasima.core.util.TypeUtil;
import jasima.core.util.Util;
import jasima.core.util.ValueStore;
import jasima.core.util.ValueStoreImpl;
import jasima.core.util.observer.Notifier;
import jasima.core.util.observer.NotifierImpl;
import jasima.core.util.observer.ObservableValue;
import jasima.core.util.observer.ObservableValues;
import java.beans.PropertyDescriptor;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;

public abstract class Experiment
implements Notifier<Experiment, ExperimentEvent>,
ValueStore,
Cloneable,
Serializable {
    public static final long DEFAULT_SEED = 902790708899L;
    private static final long serialVersionUID = -5981694222402234985L;
    public static final String RUNTIME = "runTime";
    public static final String EXP_ABORTED = "expAborted";
    public static final String EXCEPTION = "exception";
    public static final String EXCEPTION_MESSAGE = "exceptionMessage";
    private String name = null;
    private long initialSeed = 902790708899L;
    private MsgCategory logLevel = MsgCategory.INFO;
    private NotifierImpl<Experiment, ExperimentEvent> notifierAdapter;
    private ValueStoreImpl valueStore;
    private transient int nestingLevel = 0;
    private transient long runTimeReal;
    protected volatile transient int aborted;
    private volatile transient boolean isCancelled;
    protected transient Map<String, Object> resultMap;
    protected transient Throwable error;
    private volatile transient ObservableValue<ExperimentState> state = ObservableValues.observable(ExperimentState.INITIAL);

    protected void starting() {
    }

    protected void init() {
    }

    protected void beforeRun() {
    }

    protected abstract void performRun();

    protected void afterRun() {
    }

    protected void done() {
    }

    protected void produceResults() {
    }

    protected void finish() {
    }

    public Map<String, Object> runExperiment() {
        this.aboutToStart();
        return this.runExperimentInternal();
    }

    public ExperimentCompletableFuture runExperimentAsync(ExecutorService pool) {
        return ExperimentExecutor.runExperimentAsync(this, null, pool);
    }

    public ExperimentCompletableFuture runExperimentAsync() {
        return this.runExperimentAsync(Util.DEF_POOL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, Object> runExperimentInternal() {
        Object object = this.state;
        synchronized (object) {
            this.requireState(ExperimentState.ABOUT_TO_START);
            this.state.set(ExperimentState.RUNNING);
        }
        try {
            this.runTimeReal = System.currentTimeMillis();
            this.aborted = 0;
            this.resultMap = new LinkedHashMap<String, Object>();
            this.isCancelled = false;
            this.error = null;
            try {
                this.starting();
                if (this.numListener() > 0) {
                    this.fire(ExperimentMessage.EXPERIMENT_STARTING);
                }
                this.init();
                if (this.numListener() > 0) {
                    this.fire(ExperimentMessage.EXPERIMENT_INITIALIZED);
                }
                this.beforeRun();
                if (this.numListener() > 0) {
                    this.fire(ExperimentMessage.EXPERIMENT_BEFORE_RUN);
                }
                this.performRun();
                if (this.numListener() > 0) {
                    this.fire(ExperimentMessage.EXPERIMENT_RUN_PERFORMED);
                }
                this.afterRun();
                if (this.numListener() > 0) {
                    this.fire(ExperimentMessage.EXPERIMENT_AFTER_RUN);
                }
                this.done();
                if (this.numListener() > 0) {
                    this.fire(ExperimentMessage.EXPERIMENT_DONE);
                }
                this.checkCancelledOrInterrupted();
                if (this.numListener() > 0) {
                    this.fire(ExperimentMessage.EXPERIMENT_COLLECTING_RESULTS);
                }
                this.produceResults();
            }
            finally {
                this.runTimeReal = System.currentTimeMillis() - this.runTimeReal;
                this.addStandardResults();
            }
            if (this.numListener() > 0) {
                this.fire(ExperimentMessage.EXPERIMENT_FINISHING);
            }
            this.finish();
            if (this.numListener() > 0) {
                this.fire(ExperimentMessage.EXPERIMENT_FINISHED);
            }
            object = this.getResults();
        }
        catch (Throwable t) {
            try {
                try {
                    this.handleExecutionError(t);
                    throw t;
                }
                catch (Throwable ignore) {
                    ignore.printStackTrace();
                }
                throw t;
            }
            catch (Throwable throwable) {
                try {
                    this.finalActions();
                    if (this.numListener() > 0) {
                        this.fire(ExperimentMessage.EXPERIMENT_FINALLY);
                    }
                    this.state.set(this.error == null ? ExperimentState.FINISHED : ExperimentState.ERROR);
                    throw throwable;
                }
                catch (Throwable ignore) {
                    try {
                        ignore.printStackTrace();
                        this.state.set(this.error == null ? ExperimentState.FINISHED : ExperimentState.ERROR);
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        this.state.set(this.error == null ? ExperimentState.FINISHED : ExperimentState.ERROR);
                        throw throwable2;
                    }
                }
            }
        }
        try {
            this.finalActions();
            if (this.numListener() > 0) {
                this.fire(ExperimentMessage.EXPERIMENT_FINALLY);
            }
            this.state.set(this.error == null ? ExperimentState.FINISHED : ExperimentState.ERROR);
            return object;
        }
        catch (Throwable ignore) {
            try {
                ignore.printStackTrace();
                this.state.set(this.error == null ? ExperimentState.FINISHED : ExperimentState.ERROR);
                return object;
            }
            catch (Throwable throwable) {
                this.state.set(this.error == null ? ExperimentState.FINISHED : ExperimentState.ERROR);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void aboutToStart() {
        ObservableValue<ExperimentState> observableValue = this.state;
        synchronized (observableValue) {
            this.requireState(ExperimentState.INITIAL);
            this.state.set(ExperimentState.ABOUT_TO_START);
        }
    }

    protected void requireState(ExperimentState expected) {
        ExperimentState current = this.state.get();
        if (current != expected) {
            throw new IllegalStateException("State expected " + (Object)((Object)expected) + ", but was " + (Object)((Object)current) + ". An experiment can only run once.");
        }
    }

    protected void handleExecutionError(Throwable t) {
        this.error = t;
        this.aborted = 1;
        this.addErrorResults();
        if (this.numListener() > 0) {
            this.fire(ExperimentMessage.EXPERIMENT_ERROR);
        }
    }

    protected void finalActions() {
    }

    protected void checkCancelledOrInterrupted() throws CancellationException {
        if (this.isCancelled()) {
            throw new CancellationException("Execution cancelled.");
        }
        if (Thread.interrupted()) {
            Thread.currentThread().interrupt();
            throw new CancellationException("Execution interrupted.");
        }
    }

    protected void addStandardResults() {
        this.resultMap.put(RUNTIME, this.runTimeReal());
        this.resultMap.put(EXP_ABORTED, this.aborted);
    }

    protected void addErrorResults() {
        this.resultMap.put(EXP_ABORTED, this.aborted);
        this.resultMap.put(EXCEPTION_MESSAGE, this.error.getMessage());
        this.resultMap.put(EXCEPTION, Util.exceptionToString(this.error));
    }

    public void cancel() {
        this.abort();
        this.isCancelled = true;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void abort() {
        this.aborted = 1;
    }

    public final Map<String, Object> getResults() {
        return Collections.unmodifiableMap(this.resultMap);
    }

    public final Throwable getError() {
        return this.error;
    }

    public final ObservableValue<ExperimentState> state() {
        return this.state;
    }

    public final ExperimentState getState() {
        return this.state.get();
    }

    protected double runTimeReal() {
        return (double)this.runTimeReal / 1000.0;
    }

    protected ExperimentCompletableFuture executeSubExperiment(Experiment sub) {
        sub.nestingLevel(this.nestingLevel() + 1);
        return ExperimentExecutor.runExperimentAsync(sub, this);
    }

    public Map<String, Object> getPropsWithValues() {
        PropertyDescriptor[] pds = TypeUtil.findWritableProperties(this);
        return TypeUtil.getPropertyValues(this, pds);
    }

    public void print(String message) {
        this.print(MsgCategory.INFO, message);
    }

    public void print(MsgCategory category, String message) {
        if (this.numListener() > 0 && category.ordinal() <= this.getLogLevel().ordinal()) {
            this.fire(new ExperimentMessage.ExpPrintMessage(this, category, message));
        }
    }

    public void print(MsgCategory category, String messageFormat, Object ... params) {
        if (this.numListener() > 0 && category.ordinal() <= this.getLogLevel().ordinal()) {
            this.fire(new ExperimentMessage.ExpPrintMessage(this, category, messageFormat, params));
        }
    }

    public void print(String messageFormat, Object ... params) {
        this.print(MsgCategory.INFO, messageFormat, params);
    }

    public final void printResults() {
        ConsolePrinter.printResults(this, this.getResults());
    }

    public void nestingLevel(int nestingLevel) {
        this.nestingLevel = nestingLevel;
    }

    public int nestingLevel() {
        return this.nestingLevel;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public long getInitialSeed() {
        return this.initialSeed;
    }

    public void setInitialSeed(long initialSeed) {
        this.initialSeed = initialSeed;
    }

    public MsgCategory getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(MsgCategory logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public ValueStore valueStoreImpl() {
        if (this.valueStore == null) {
            this.valueStore = new ValueStoreImpl();
        }
        return this.valueStore;
    }

    @Override
    public NotifierImpl<Experiment, ExperimentEvent> notifierImpl() {
        if (this.notifierAdapter == null) {
            this.notifierAdapter = new NotifierImpl(this);
        }
        return this.notifierAdapter;
    }

    public Experiment clone() {
        try {
            Experiment c = (Experiment)super.clone();
            c.state = ObservableValues.observable(ExperimentState.INITIAL);
            if (this.notifierAdapter != null) {
                c.notifierAdapter = new NotifierImpl(c);
                for (int i = 0; i < this.numListener(); ++i) {
                    c.addListener(TypeUtil.cloneIfPossible(this.getListener(i)));
                }
            }
            if (this.valueStore != null) {
                c.valueStore = this.valueStore.clone();
            }
            return c;
        }
        catch (CloneNotSupportedException shouldntHappen) {
            throw new RuntimeException(shouldntHappen);
        }
    }

    public String toString() {
        return this.getName() == null ? "exp@" + Integer.toHexString(this.hashCode()) : this.getName();
    }

    protected Object readResolve() throws ObjectStreamException {
        this.state = ObservableValues.observable(ExperimentState.INITIAL);
        return this;
    }

    public static void main(String ... args) throws Exception {
        Class<?> klazz = TypeUtil.getMainClass();
        Class<Experiment> ec = klazz.asSubclass(Experiment.class);
        Experiment e = ec.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        new ConsoleRunner(e).runWith(args);
    }

    @Deprecated
    public static class UniqueNamesCheckingHashMap
    extends LinkedHashMap<String, Object> {
        private static final long serialVersionUID = -6783419937586790463L;
        private boolean disableCheck;

        @Override
        public Object put(String key, Object value) {
            if (!this.isDisableCheck() && this.containsKey(key)) {
                throw new RuntimeException("Map already contains value '" + key + "'.");
            }
            return super.put(key.intern(), value);
        }

        public boolean isDisableCheck() {
            return this.disableCheck;
        }

        public void setDisableCheck(boolean disableCheck) {
            this.disableCheck = disableCheck;
        }
    }

    public static enum ExperimentState {
        INITIAL,
        ABOUT_TO_START,
        RUNNING,
        FINISHED,
        ERROR;

    }

    public static interface ExperimentEvent {
    }
}

