/*
 * Decompiled with CFR 0.152.
 */
package jasima.core.experiment;

import jasima.core.expExecution.ExperimentExecutor;
import jasima.core.experiment.Experiment;
import jasima.core.experiment.ExperimentCompletableFuture;
import jasima.core.statistics.SummaryStat;
import jasima.core.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public abstract class AbstractMultiExperiment
extends Experiment {
    private static final long serialVersionUID = 2285355204835181022L;
    public static final String NUM_TASKS_EXECUTED = "numTasks";
    private boolean allowParallelExecution = true;
    private boolean commonRandomNumbers = true;
    private int skipSeedCount = 0;
    private boolean abortUponBaseExperimentAbort = false;
    private String[] keepResults = new String[0];
    private boolean produceAveragedResults = true;
    protected Map<String, Object> detailedResultsNumeric;
    protected Map<String, Object> detailedResultsOther;
    protected Random seedStream;
    protected List<Experiment> experiments;
    protected int numTasksExecuted;

    @Override
    public void init() {
        super.init();
        this.experiments = new ArrayList<Experiment>();
        this.seedStream = null;
        this.detailedResultsNumeric = new HashMap<String, Object>();
        this.detailedResultsOther = new HashMap<String, Object>();
        this.numTasksExecuted = 0;
        for (int i = 0; i < this.getSkipSeedCount(); ++i) {
            this.getExperimentSeed();
        }
    }

    @Override
    protected void performRun() {
        do {
            this.createExperiments();
            this.executeExperiments();
        } while (this.hasMoreTasks());
        this.experiments.clear();
    }

    protected boolean hasMoreTasks() {
        return false;
    }

    protected abstract void createExperiments();

    protected void executeExperiments() {
        block8: {
            try {
                if (this.isAllowParallelExecution()) {
                    int n = 0;
                    Collection<ExperimentCompletableFuture> allFutures = ExperimentExecutor.runAllExperiments(this.experiments, this);
                    Iterator<ExperimentCompletableFuture> it = allFutures.iterator();
                    while (it.hasNext()) {
                        ExperimentCompletableFuture f = it.next();
                        it.remove();
                        assert (f.getExperiment() == this.experiments.get(n));
                        this.getAndStoreResults(this.experiments.get(n), f);
                        this.experiments.set(n, null);
                        ++n;
                        if (this.aborted == 0) continue;
                        for (ExperimentCompletableFuture f2 : allFutures) {
                            f2.cancel(true);
                        }
                        break block8;
                    }
                    break block8;
                }
                for (int i = 0; i < this.experiments.size(); ++i) {
                    Experiment e = this.experiments.get(i);
                    this.experiments.set(i, null);
                    if (this.aborted == 0) {
                        ExperimentCompletableFuture future = ExperimentExecutor.runExperimentAsync(e, this);
                        this.getAndStoreResults(e, future);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void getAndStoreResults(Experiment e, ExperimentCompletableFuture f) throws InterruptedException {
        Map<String, Object> res = f.joinIgnoreExceptions();
        ++this.numTasksExecuted;
        this.storeRunResults(e, res);
        this.fire(new BaseExperimentCompleted(e, res));
    }

    protected void configureRunExperiment(Experiment e) {
        e.setInitialSeed(this.getExperimentSeed());
        e.nestingLevel(this.nestingLevel() + 1);
        String name = this.prefix() + this.padNumTasks(this.experiments.size() + 1);
        if (e.getName() != null) {
            name = name + "." + e.getName();
        }
        e.setName(name);
    }

    protected long getExperimentSeed() {
        if (this.isCommonRandomNumbers()) {
            return this.getInitialSeed();
        }
        if (this.seedStream == null) {
            this.seedStream = new Random(this.getInitialSeed());
        }
        return this.seedStream.nextLong();
    }

    protected void storeRunResults(Experiment e, Map<String, Object> r) {
        Integer subAborted = (Integer)r.get("expAborted");
        if (subAborted != null && subAborted > 0 && this.isAbortUponBaseExperimentAbort()) {
            this.abort();
        }
        for (String key : r.keySet()) {
            Object val = r.get(key);
            if (this.shouldKeepDetails(key)) {
                this.detailedResultsOther.put(key + "." + this.prefix() + this.padNumTasks(this.getNumTasksExecuted()), r.get(key));
            }
            if (!this.isProduceAveragedResults()) continue;
            if (val != null && (val instanceof SummaryStat || val instanceof Number)) {
                this.handleNumericValue(key, val);
                continue;
            }
            this.handleOtherValue(key, val);
        }
    }

    private boolean shouldKeepDetails(String key) {
        for (String s : this.keepResults) {
            if (!s.equals(key) && !key.startsWith(s + '.')) continue;
            return true;
        }
        return false;
    }

    private String padNumTasks(int v) {
        int l = String.valueOf(this.getNumExperiments()).length();
        StringBuilder sb = new StringBuilder(l);
        sb.append(v);
        while (sb.length() < l) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }

    public abstract int getNumExperiments();

    public int getNumTasks() {
        return this.experiments.size();
    }

    public int getNumTasksExecuted() {
        return this.numTasksExecuted;
    }

    protected abstract String prefix();

    protected void handleOtherValue(String key, Object val) {
        ArrayList<Object> l;
        if (key.endsWith("exception") || key.endsWith("exceptionMessage")) {
            key = "baseExperiment." + key;
        }
        if ((l = (ArrayList<Object>)this.detailedResultsOther.get(key)) == null) {
            l = new ArrayList<Object>();
            this.detailedResultsOther.put(key, l);
        }
        l.add(val);
    }

    protected void handleNumericValue(String key, Object val) {
        Double v;
        boolean wasSummaryStat;
        if (val instanceof SummaryStat) {
            SummaryStat vs = (SummaryStat)val;
            wasSummaryStat = true;
            v = vs.numObs() > 0 ? Double.valueOf(vs.mean()) : null;
        } else if (val instanceof Number) {
            Number n = (Number)val;
            v = n.doubleValue();
            wasSummaryStat = false;
        } else {
            throw new AssertionError((Object)("Illegal experiment result type: " + val.getClass().getName()));
        }
        Pair<Boolean, SummaryStat> data = (Pair<Boolean, SummaryStat>)this.detailedResultsNumeric.get(key);
        if (data == null) {
            data = new Pair<Boolean, SummaryStat>(wasSummaryStat, new SummaryStat());
            this.detailedResultsNumeric.put(key, data);
        }
        SummaryStat repValues = (SummaryStat)data.b;
        if (v != null) {
            repValues.value(v);
        }
    }

    protected boolean isSpecialKey(String key) {
        return key.endsWith("runTime") || key.endsWith(NUM_TASKS_EXECUTED) || key.endsWith("expAborted");
    }

    @Override
    protected void produceResults() {
        super.produceResults();
        for (String key : this.detailedResultsNumeric.keySet()) {
            Pair data = (Pair)this.detailedResultsNumeric.get(key);
            SummaryStat val = (SummaryStat)data.b;
            if (this.isSpecialKey(key)) {
                key = "baseExperiment." + key;
            } else if (((Boolean)data.a).booleanValue()) {
                key = key + ".mean";
            }
            this.resultMap.put(key, val);
        }
        for (String key : this.detailedResultsOther.keySet()) {
            Object[] val = this.detailedResultsOther.get(key);
            while (this.resultMap.containsKey(key)) {
                key = key + "@Other";
            }
            if (val instanceof ArrayList) {
                ArrayList l = (ArrayList)val;
                val = l.toArray(new Object[l.size()]);
            }
            this.resultMap.put(key, val);
        }
        this.resultMap.put(NUM_TASKS_EXECUTED, this.getNumTasksExecuted());
    }

    @Override
    public AbstractMultiExperiment clone() {
        AbstractMultiExperiment mre = (AbstractMultiExperiment)super.clone();
        if (this.keepResults != null) {
            mre.keepResults = (String[])this.keepResults.clone();
        }
        return mre;
    }

    public void addKeepResultName(String name) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(this.keepResults));
        list.add(name);
        this.keepResults = list.toArray(new String[list.size()]);
    }

    public boolean removeKeepResultName(String name) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(this.keepResults));
        boolean res = list.remove(name);
        this.keepResults = list.toArray(new String[list.size()]);
        return res;
    }

    public boolean isKeepTaskResults() {
        return this.keepResults.length > 0;
    }

    public String[] getKeepResults() {
        return this.keepResults;
    }

    public void setKeepResults(String ... keepResults) {
        this.keepResults = keepResults;
    }

    public void setAllowParallelExecution(boolean allowParallelExecution) {
        this.allowParallelExecution = allowParallelExecution;
    }

    public boolean isAllowParallelExecution() {
        return this.allowParallelExecution;
    }

    protected void setCommonRandomNumbers(boolean commonRandomNumbers) {
        this.commonRandomNumbers = commonRandomNumbers;
    }

    public boolean isCommonRandomNumbers() {
        return this.commonRandomNumbers;
    }

    public void setSkipSeedCount(int skipSeedCount) {
        this.skipSeedCount = skipSeedCount;
    }

    public int getSkipSeedCount() {
        return this.skipSeedCount;
    }

    public void setAbortUponBaseExperimentAbort(boolean abortUponBaseExperimentAbort) {
        this.abortUponBaseExperimentAbort = abortUponBaseExperimentAbort;
    }

    public boolean isAbortUponBaseExperimentAbort() {
        return this.abortUponBaseExperimentAbort;
    }

    public boolean isProduceAveragedResults() {
        return this.produceAveragedResults;
    }

    public void setProduceAveragedResults(boolean produceAveragedResults) {
        this.produceAveragedResults = produceAveragedResults;
    }

    public static class BaseExperimentCompleted
    implements Experiment.ExperimentEvent {
        public final Experiment experimentRun;
        public final Map<String, Object> results;

        public BaseExperimentCompleted(Experiment experimentRun, Map<String, Object> results) {
            this.experimentRun = experimentRun;
            this.results = results;
        }

        public String toString() {
            return "BaseExperimentCompleted#";
        }
    }
}

